/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crafting;

import com.denfop.api.Recipes;
import com.denfop.api.crafting.PartRecipe;
import com.denfop.api.crafting.RecipeGrid;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.IngredientInput;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.register.Register;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class BaseRecipe
extends ShapedRecipe {
    private final ItemStack output;
    private final int[][] inputIndex;
    private final int[] inputIndexCraftingTable = new int[4];
    private final IInputItemStack[][] input;
    private final int size;
    private final NonNullList<Ingredient> listIngridient;
    private final NonNullList<IInputItemStack> listInput;
    private final int minX;
    private final int minY;
    private final int x;
    private final int y;
    private final int index;
    private final String id;
    private final List<PartRecipe> partRecipe;
    private final RecipeGrid recipeGrid;

    public BaseRecipe(ResourceLocation id, String group, ItemStack output, RecipeGrid recipeGrid, List<PartRecipe> partRecipe) {
        super(id, group, recipeGrid.isHasTwoX() ? 2 : 3, recipeGrid.isHasTwoY() ? 2 : 3, NonNullList.m_122779_(), output);
        int j;
        this.output = output;
        this.size = recipeGrid.getGrids().size();
        this.minX = recipeGrid.isHasTwoX() ? 2 : 3;
        this.minY = recipeGrid.isHasTwoY() ? 2 : 3;
        this.x = recipeGrid.getX2();
        this.y = recipeGrid.getY2();
        this.index = recipeGrid.getIndex();
        this.inputIndex = new int[recipeGrid.getGrids().size()][9];
        this.input = new IInputItemStack[recipeGrid.getGrids().size()][9];
        this.partRecipe = partRecipe;
        this.recipeGrid = recipeGrid;
        for (j = 0; j < recipeGrid.getGrids().size(); ++j) {
            for (PartRecipe recipe : partRecipe) {
                List<Integer> integerList = recipeGrid.getIndexesInGrid(j, recipe);
                for (int i : integerList) {
                    this.inputIndex[j][i] = 1;
                    this.input[j][i] = recipe.getInput();
                }
            }
        }
        this.listIngridient = NonNullList.m_122779_();
        this.listInput = NonNullList.m_122779_();
        for (int x = 0; x < 9; ++x) {
            if (this.inputIndex[0][x] != 0) {
                this.listIngridient.add((Object)new IngredientInput(this.input[0][x]).getInput());
                this.listInput.add((Object)this.input[0][x]);
                continue;
            }
            this.listInput.add((Object)InputItemStack.EMPTY);
            this.listIngridient.add((Object)Ingredient.f_43901_);
        }
        if (this.minX == 2 && this.minY == 2) {
            j = 0;
            for (int x = 0; x < 3; ++x) {
                if (x == this.x) continue;
                for (int y = 0; y < 3; ++y) {
                    if (this.y == y) continue;
                    this.inputIndexCraftingTable[j] = x + y * 3;
                    ++j;
                }
            }
        }
        this.id = id.toString();
    }

    public BaseRecipe(ItemStack output, RecipeGrid recipeGrid, List<PartRecipe> partRecipe) {
        super(ResourceLocation.m_135820_((String)"minecraft:minecraft"), "", recipeGrid.isHasTwoX() ? 2 : 3, recipeGrid.isHasTwoY() ? 2 : 3, NonNullList.m_122779_(), output);
        int j;
        this.output = output;
        this.size = recipeGrid.getGrids().size();
        this.minX = recipeGrid.isHasTwoX() ? 2 : 3;
        this.minY = recipeGrid.isHasTwoY() ? 2 : 3;
        this.x = recipeGrid.getX2();
        this.y = recipeGrid.getY2();
        this.index = recipeGrid.getIndex();
        this.inputIndex = new int[recipeGrid.getGrids().size()][9];
        this.input = new IInputItemStack[recipeGrid.getGrids().size()][9];
        this.partRecipe = partRecipe;
        this.recipeGrid = recipeGrid;
        for (j = 0; j < recipeGrid.getGrids().size(); ++j) {
            for (PartRecipe recipe : partRecipe) {
                List<Integer> integerList = recipeGrid.getIndexesInGrid(j, recipe);
                for (int i : integerList) {
                    this.inputIndex[j][i] = 1;
                    this.input[j][i] = recipe.getInput();
                }
            }
        }
        this.listIngridient = NonNullList.m_122779_();
        this.listInput = NonNullList.m_122779_();
        for (int x = 0; x < 9; ++x) {
            if (this.inputIndex[0][x] != 0) {
                this.listIngridient.add((Object)new IngredientInput(this.input[0][x]).getInput());
                this.listInput.add((Object)this.input[0][x]);
                continue;
            }
            this.listInput.add((Object)InputItemStack.EMPTY);
            this.listIngridient.add((Object)Ingredient.f_43901_);
        }
        if (this.minX == 2 && this.minY == 2) {
            j = 0;
            for (int x = 0; x < 3; ++x) {
                if (x == this.x) continue;
                for (int y = 0; y < 3; ++y) {
                    if (this.y == y) continue;
                    this.inputIndexCraftingTable[j] = x + y * 3;
                    ++j;
                }
            }
        }
        this.id = Recipes.registerRecipe((Recipe)this);
    }

    public static BaseRecipe create(ResourceLocation id, CustomPacketBuffer customPacketBuffer) {
        try {
            String group = (String)DecoderHandler.decode(customPacketBuffer);
            ItemStack output = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            List args = (List)DecoderHandler.decode(customPacketBuffer);
            RecipeGrid grid = new RecipeGrid(args);
            ArrayList<PartRecipe> partRecipes = new ArrayList<PartRecipe>();
            int size = customPacketBuffer.readInt();
            for (int i = 0; i < size; ++i) {
                partRecipes.add(new PartRecipe((String)DecoderHandler.decode(customPacketBuffer), InputItemStack.create((CompoundTag)DecoderHandler.decode(customPacketBuffer))));
            }
            return new BaseRecipe(id, group, output, grid, partRecipes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NonNullList<IInputItemStack> getListInput() {
        return this.listInput;
    }

    public List<PartRecipe> getPartRecipe() {
        return this.partRecipe;
    }

    public RecipeGrid getRecipeGrid() {
        return this.recipeGrid;
    }

    public int[] getInputIndex() {
        return this.inputIndex[0];
    }

    public IInputItemStack[] getInput() {
        return this.input[0];
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean m_5818_(CraftingContainer pInv, Level pLevel) {
        return this.matches(pInv) != ItemStack.f_41583_;
    }

    public ItemStack m_5874_(CraftingContainer container) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return 3 == p_43999_ && p_44000_ == 3;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer p_44004_) {
        return NonNullList.m_122780_((int)p_44004_.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int x = 0; x < 9; ++x) {
            if (this.inputIndex[0][x] != 0) {
                ingredients.add((Object)(this.input[0][x].hasTag() ? Ingredient.m_204132_(this.input[0][x].getTag()) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input[0][x].getInputs().get(0)})));
                continue;
            }
            ingredients.add((Object)Ingredient.f_43901_);
        }
        return ingredients;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Register.RECIPE_SERIALIZER_SHAPED_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }

    public ItemStack matches(CraftingContainer inv) {
        int width = (int)Math.sqrt(inv.m_6643_());
        int height = inv.m_6643_() / width;
        if (width < 3 || height < 3) {
            if (this.minY == 2 && this.minX == 2 && width == 2 && height == 2) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack offer = inv.m_8020_(i);
                    if (this.inputIndex[this.index][this.inputIndexCraftingTable[i]] == 0 && !offer.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    if (this.inputIndex[this.index][this.inputIndexCraftingTable[i]] != 0 && offer.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    if (this.inputIndex[this.index][this.inputIndexCraftingTable[i]] == 0 && offer.m_41619_()) continue;
                    if (this.input[this.index][this.inputIndexCraftingTable[i]] instanceof InputOreDict && this.input[this.index][this.inputIndexCraftingTable[i]].hasTag() && this.input[this.index][this.inputIndexCraftingTable[i]].getInputs().isEmpty()) {
                        this.input[this.index][this.inputIndexCraftingTable[i]] = new InputOreDict(this.input[this.index][this.inputIndexCraftingTable[i]].getTag(), this.input[this.index][this.inputIndexCraftingTable[i]].getAmount());
                    }
                    if (this.input[this.index][this.inputIndexCraftingTable[i]].matches(offer)) continue;
                    return ItemStack.f_41583_;
                }
                return this.output.m_41777_();
            }
            return ItemStack.f_41583_;
        }
        for (int j = 0; j < this.size; ++j) {
            if (j != this.size - 1) {
                boolean has = true;
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    ItemStack offer = inv.m_8020_(i);
                    if (this.inputIndex[j][i] == 0 && !offer.m_41619_()) {
                        has = false;
                        break;
                    }
                    if (this.inputIndex[j][i] != 0 && offer.m_41619_()) {
                        has = false;
                        break;
                    }
                    if (this.inputIndex[j][i] == 0 && offer.m_41619_()) continue;
                    if (this.input[j][i] instanceof InputOreDict && this.input[j][i].hasTag() && this.input[j][i].getInputs().isEmpty()) {
                        this.input[j][i] = new InputOreDict(this.input[j][i].getTag(), this.input[j][i].getAmount());
                    }
                    if (this.input[j][i].matches(offer)) continue;
                    has = false;
                    break;
                }
                if (!has) continue;
                return this.output.m_41777_();
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack offer = inv.m_8020_(i);
                if (this.inputIndex[j][i] == 0 && !offer.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                if (this.inputIndex[j][i] != 0 && offer.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                if (this.inputIndex[j][i] == 0 && offer.m_41619_()) continue;
                if (this.input[j][i] instanceof InputOreDict && this.input[j][i].hasTag() && this.input[j][i].getInputs().isEmpty()) {
                    this.input[j][i] = new InputOreDict(this.input[j][i].getTag(), this.input[j][i].getAmount());
                }
                if (this.input[j][i].matches(offer)) continue;
                return ItemStack.f_41583_;
            }
        }
        return this.output.m_41777_();
    }

    public void toNetwork(FriendlyByteBuf buf) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer((ByteBuf)buf);
        try {
            EncoderHandler.encode(packetBuffer, this.m_6076_());
            EncoderHandler.encode(packetBuffer, this.output);
            this.recipeGrid.encode(packetBuffer);
            packetBuffer.writeInt(this.partRecipe.size());
            for (PartRecipe part : this.partRecipe) {
                part.encode(packetBuffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

