/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crop.genetics;

import com.denfop.api.crop.genetics.EnumGenetic;
import com.denfop.api.crop.genetics.GeneticsManager;
import com.denfop.api.pollution.component.LevelPollution;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import java.util.ArrayList;
import java.util.List;

public enum GeneticTraits {
    SOIL_I(EnumGenetic.SOIL, LevelPollution.MEDIUM, null),
    SOIL_II(EnumGenetic.SOIL, LevelPollution.HIGH, SOIL_I),
    SOIL_III(EnumGenetic.SOIL, LevelPollution.VERY_HIGH, SOIL_II),
    CHANCE_I(EnumGenetic.CHANCE, 3, null),
    CHANCE_II(EnumGenetic.CHANCE, 5, CHANCE_I),
    CHANCE_III(EnumGenetic.CHANCE, 8, CHANCE_II),
    BEECOMBINE(EnumGenetic.BEE, true, null),
    YIELD_I(EnumGenetic.YIELD, 2, null),
    YIELD_II(EnumGenetic.YIELD, 3, YIELD_I),
    YIELD_III(EnumGenetic.YIELD, 5, YIELD_II),
    WEATHER_I(EnumGenetic.WEATHER, 1, null),
    WEATHER_II(EnumGenetic.WEATHER, 2, WEATHER_I),
    WATER(EnumGenetic.WATER, true, null),
    LIGHT_I(EnumGenetic.LIGHT, 9, null),
    LIGHT_II(EnumGenetic.LIGHT, 6, LIGHT_I),
    LIGHT_III(EnumGenetic.LIGHT, 3, LIGHT_II),
    LIGHT_IV(EnumGenetic.LIGHT, 0, LIGHT_III),
    BIOME_I(EnumGenetic.BIOME, 1, null),
    BIOME_II(EnumGenetic.BIOME, 2, null),
    BIOME(EnumGenetic.BIOME, 3, null),
    BIOME_III(EnumGenetic.BIOME, 4, null),
    BIOME_IV(EnumGenetic.BIOME, 5, null),
    GROW_SPEED_I(EnumGenetic.GROW_SPEED, 1.25, null),
    GROW_SPEED_II(EnumGenetic.GROW_SPEED, 1.5, GROW_SPEED_I),
    GROW_SPEED_III(EnumGenetic.GROW_SPEED, 2.0, GROW_SPEED_II),
    PEST_I(EnumGenetic.PEST, 5, null),
    PEST_II(EnumGenetic.PEST, 10, PEST_I),
    PEST_III(EnumGenetic.PEST, 15, PEST_II),
    SEED_I(EnumGenetic.SEED, 2, null),
    SEED_II(EnumGenetic.SEED, 3, SEED_I),
    SEED_III(EnumGenetic.SEED, 4, SEED_II),
    WEED_I(EnumGenetic.WEED, 1, null),
    WEED_II(EnumGenetic.WEED, 2, WEED_I),
    WEED_III(EnumGenetic.WEED, 3, WEED_II),
    SOIL_BLOCK(EnumGenetic.SOIL_BLOCK, true, null),
    SUN(EnumGenetic.SUN, true, null),
    NIGHT_GROW(EnumGenetic.NIGHT_GROW, true, null),
    AIR_I(EnumGenetic.AIR, LevelPollution.MEDIUM, null),
    AIR_II(EnumGenetic.AIR, LevelPollution.HIGH, AIR_I),
    AIR_III(EnumGenetic.AIR, LevelPollution.VERY_HIGH, AIR_II),
    RADIATION_I(EnumGenetic.RADIATION, EnumLevelRadiation.MEDIUM, null),
    RADIATION_II(EnumGenetic.RADIATION, EnumLevelRadiation.HIGH, RADIATION_I),
    RADIATION_III(EnumGenetic.RADIATION, EnumLevelRadiation.VERY_HIGH, RADIATION_II),
    GENOME_RESISTANCE_I(EnumGenetic.GENOME_RESISTANCE, 25, null),
    GENOME_RESISTANCE_II(EnumGenetic.GENOME_RESISTANCE, 50, GENOME_RESISTANCE_I),
    GENOME_RESISTANCE_III(EnumGenetic.GENOME_RESISTANCE, 100, GENOME_RESISTANCE_II),
    GENOME_ADAPTIVE_I(EnumGenetic.GENOME_ADAPTIVE, 20, null),
    GENOME_ADAPTIVE_II(EnumGenetic.GENOME_ADAPTIVE, 40, GENOME_ADAPTIVE_I),
    GENOME_ADAPTIVE_III(EnumGenetic.GENOME_ADAPTIVE, 60, GENOME_ADAPTIVE_II);

    private final EnumGenetic genetic;
    private final Object value;
    private final GeneticTraits prev;

    private <T> GeneticTraits(EnumGenetic genetic, T value, GeneticTraits prev) {
        List<GeneticTraits> geneticTraits;
        this.genetic = genetic;
        this.value = value;
        this.prev = prev;
        if (prev != null) {
            GeneticsManager.geneticTraitsMap.put(prev, this);
        }
        if ((geneticTraits = GeneticsManager.enumGeneticListMap.get((Object)genetic)) == null) {
            geneticTraits = new ArrayList<GeneticTraits>();
            geneticTraits.add(this);
            GeneticsManager.enumGeneticListMap.put(genetic, geneticTraits);
        } else {
            geneticTraits.add(this);
        }
    }

    public static void init() {
        for (GeneticTraits genetic : GeneticTraits.values()) {
            List<GeneticTraits> geneticTraits;
            if (genetic.prev != null) {
                GeneticsManager.geneticTraitsMap.put(genetic.prev, genetic);
            }
            if ((geneticTraits = GeneticsManager.enumGeneticListMap.get((Object)genetic.genetic)) == null) {
                geneticTraits = new ArrayList<GeneticTraits>();
                geneticTraits.add(genetic);
                GeneticsManager.enumGeneticListMap.put(genetic.genetic, geneticTraits);
                continue;
            }
            geneticTraits.add(genetic);
        }
    }

    public GeneticTraits getPrev() {
        return this.prev;
    }

    public <T> T getValue(Class<T> type) {
        return type.cast(this.value);
    }

    public EnumGenetic getGenetic() {
        return this.genetic;
    }
}

