/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crop.genetics;

import com.denfop.api.crop.Crop;
import com.denfop.api.crop.genetics.EnumGenetic;
import com.denfop.api.crop.genetics.GeneticTraits;
import com.denfop.api.crop.genetics.GenomeBase;
import com.denfop.api.pollution.component.LevelPollution;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class Genome
implements GenomeBase {
    public static Map<GeneticTraits, List<ResourceKey<Biome>>> geneticBiomes = new HashMap<GeneticTraits, List<ResourceKey<Biome>>>();
    Map<EnumGenetic, GeneticTraits> geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>();
    private ItemStack stack;

    public Genome(ItemStack stack) {
        CompoundTag nbt;
        CompoundTag nbt1 = ModUtils.nbt(stack);
        if (!nbt1.m_128441_("genome")) {
            nbt = new CompoundTag();
            nbt1.m_128365_("genome", (Tag)nbt);
        }
        nbt = nbt1.m_128469_("genome");
        ListTag tagList = nbt.m_128437_("genomeList", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag genomeNbt = tagList.m_128728_(i);
            byte meta = genomeNbt.m_128445_("meta");
            GeneticTraits geneticTraits = GeneticTraits.values()[meta];
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
        }
        this.stack = stack;
    }

    public Genome(Map<EnumGenetic, GeneticTraits> geneticTraitsMap) {
        this.geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>(geneticTraitsMap);
    }

    private static GeneticTraits getTemperatureCategory(Biome biome) {
        if (biome.m_47554_() < 0.1f) {
            return GeneticTraits.BIOME_IV;
        }
        if (biome.m_47554_() < 0.5f) {
            return GeneticTraits.BIOME_III;
        }
        if (biome.m_47554_() < 1.0f) {
            return GeneticTraits.BIOME;
        }
        if (biome.m_47554_() < 1.5f) {
            return GeneticTraits.BIOME_I;
        }
        return GeneticTraits.BIOME_II;
    }

    public static void init() {
        for (Map.Entry biome : ForgeRegistries.BIOMES.getEntries()) {
            GeneticTraits geneticTraits = Genome.getTemperatureCategory((Biome)biome.getValue());
            List<ResourceKey<Biome>> biomes = geneticBiomes.get((Object)geneticTraits);
            if (biomes != null) {
                biomes.add((ResourceKey<Biome>)((ResourceKey)biome.getKey()));
                continue;
            }
            biomes = new ArrayList<ResourceKey<Biome>>();
            biomes.add((ResourceKey<Biome>)((ResourceKey)biome.getKey()));
            geneticBiomes.put(geneticTraits, biomes);
        }
    }

    public Map<EnumGenetic, GeneticTraits> getGeneticTraitsMap() {
        return this.geneticTraitsMap;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Genome genome = (Genome)o;
        return this.geneticTraitsMap.values().size() == genome.geneticTraitsMap.size() && this.checkGenomes(genome);
    }

    private boolean checkGenomes(Genome genome) {
        ArrayList<GeneticTraits> geneticTraits = new ArrayList<GeneticTraits>(genome.geneticTraitsMap.values());
        ArrayList<GeneticTraits> geneticTraits1 = new ArrayList<GeneticTraits>(this.geneticTraitsMap.values());
        geneticTraits1.removeIf(geneticTraits::contains);
        return geneticTraits1.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.geneticTraitsMap);
    }

    public void addGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public void addGenome(GeneticTraits geneticTraits) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(this.stack));
        }
    }

    public void removeGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.remove((Object)geneticTraits.getGenetic(), (Object)geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public GeneticTraits removeGenome(EnumGenetic genetic, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)genetic)) {
            GeneticTraits value = this.geneticTraitsMap.remove((Object)genetic);
            this.writeNBT(ModUtils.nbt(stack));
            return value;
        }
        return null;
    }

    @Override
    public CompoundTag writeNBT(CompoundTag nbtTagCompound) {
        ListTag genomeNBT = new ListTag();
        for (GeneticTraits geneticTraits : this.geneticTraitsMap.values()) {
            CompoundTag nbtTagCompound1 = new CompoundTag();
            nbtTagCompound1.m_128344_("meta", (byte)geneticTraits.ordinal());
            genomeNBT.add((Object)nbtTagCompound1);
        }
        CompoundTag nbt = nbtTagCompound.m_128469_("genome");
        nbt.m_128365_("genomeList", (Tag)genomeNBT);
        nbtTagCompound.m_128365_("genome", (Tag)nbt);
        return nbtTagCompound;
    }

    @Override
    public boolean hasGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.containsKey((Object)genome);
    }

    @Override
    public <T> T getLevelGenome(EnumGenetic genome, Class<T> tClass) {
        return this.geneticTraitsMap.get((Object)genome).getValue(tClass);
    }

    @Override
    public GeneticTraits getGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.get((Object)genome);
    }

    @Override
    public Genome copy() {
        Genome genome = new Genome(this.geneticTraitsMap);
        genome.stack = this.stack.m_41777_();
        return genome;
    }

    @Override
    public void loadCrop(Crop crop) {
        for (GeneticTraits geneticTraits : this.geneticTraitsMap.values()) {
            switch (geneticTraits) {
                case SUN: {
                    crop.setSun(true);
                    break;
                }
                case BIOME: 
                case BIOME_I: 
                case BIOME_II: 
                case BIOME_III: 
                case BIOME_IV: {
                    List<ResourceKey<Biome>> biomes = geneticBiomes.get((Object)geneticTraits);
                    biomes.forEach(crop::addBiome);
                    break;
                }
                case AIR_I: 
                case AIR_II: 
                case AIR_III: {
                    crop.setAirRequirements(geneticTraits.getValue(LevelPollution.class));
                    break;
                }
                case SOIL_I: 
                case SOIL_II: 
                case SOIL_III: {
                    crop.setSoilRequirements(geneticTraits.getValue(LevelPollution.class));
                    break;
                }
                case WATER: {
                    crop.setWaterRequirement(0);
                    break;
                }
                case PEST_I: 
                case PEST_II: 
                case PEST_III: {
                    crop.setPestResistance(geneticTraits.getValue(Integer.class));
                    break;
                }
                case WEED_I: 
                case WEED_II: 
                case WEED_III: {
                    crop.addChanceWeed(geneticTraits.getValue(Integer.class));
                    break;
                }
                case LIGHT_I: 
                case LIGHT_II: 
                case LIGHT_III: 
                case LIGHT_IV: {
                    crop.setLight(geneticTraits.getValue(Integer.class));
                    break;
                }
                case RADIATION_I: 
                case RADIATION_II: 
                case RADIATION_III: {
                    crop.setRadiationRequirements(geneticTraits.getValue(EnumLevelRadiation.class));
                    break;
                }
                case SEED_I: 
                case SEED_II: 
                case SEED_III: {
                    crop.addSizeSeed(geneticTraits.getValue(Integer.class));
                    break;
                }
                case YIELD_I: 
                case YIELD_II: 
                case YIELD_III: {
                    crop.setYield(geneticTraits.getValue(Integer.class));
                    break;
                }
                case BEECOMBINE: {
                    crop.setBeeCombine(true);
                    break;
                }
                case NIGHT_GROW: {
                    crop.setNight(true);
                    break;
                }
                case SOIL_BLOCK: {
                    crop.setIgnoreSoil(true);
                    break;
                }
                case CHANCE_I: 
                case CHANCE_II: 
                case CHANCE_III: {
                    crop.setChance(geneticTraits.getValue(Integer.class));
                    break;
                }
                case GROW_SPEED_I: 
                case GROW_SPEED_II: 
                case GROW_SPEED_III: {
                    crop.setGrowthSpeed(geneticTraits.getValue(Double.class));
                    break;
                }
                case WEATHER_I: 
                case WEATHER_II: {
                    crop.setWeatherResistance(geneticTraits.getValue(Integer.class));
                    break;
                }
                case GENOME_ADAPTIVE_I: 
                case GENOME_ADAPTIVE_II: 
                case GENOME_ADAPTIVE_III: {
                    crop.setGenomeAdaptive(geneticTraits.getValue(Integer.class));
                    break;
                }
                case GENOME_RESISTANCE_I: 
                case GENOME_RESISTANCE_II: 
                case GENOME_RESISTANCE_III: {
                    crop.setGenomeResistance(geneticTraits.getValue(Integer.class));
                }
            }
        }
    }
}

