/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy.forgeenergy;

import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.otherenergies.common.InfoTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyForge
implements EnergyTile {
    protected final Map<Direction, IEnergyStorage> storages;
    private final boolean isClientSide;
    BlockPos pos;
    List<InfoTile<EnergyTile>> validReceivers = new ArrayList<InfoTile<EnergyTile>>();
    Map<Direction, EnergyTile> energyConductorMap = new HashMap<Direction, EnergyTile>();
    private long id;

    public EnergyForge(BlockEntity blockEntity) {
        this.isClientSide = blockEntity.m_58904_().f_46443_;
        this.pos = blockEntity.m_58899_();
        this.storages = new HashMap<Direction, IEnergyStorage>();
        for (Direction direction : Direction.values()) {
            this.storages.put(direction, (IEnergyStorage)blockEntity.getCapability(ForgeCapabilities.ENERGY, direction).orElse((Object)new EnergyStorage(0, 0, 0, 0)));
        }
    }

    public Map<Direction, IEnergyStorage> getStorages() {
        return this.storages;
    }

    @Override
    public List<InfoTile<EnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(EnergyTile tile, Direction facing1) {
        if (!this.isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<EnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<EnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public void AddTile(EnergyTile tile, Direction facing1) {
        if (!this.isClientSide && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<EnergyTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public Map<Direction, EnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public int getHashCodeSource() {
        return 0;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
    }
}

