/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy.networking;

import com.denfop.api.energy.EnergyTick;
import com.denfop.api.energy.EnergyTickList;
import com.denfop.api.energy.InfoCable;
import com.denfop.api.energy.SunCoef;
import com.denfop.api.energy.event.unload.EnergyTileUnLoadEvent;
import com.denfop.api.energy.interfaces.Dual;
import com.denfop.api.energy.interfaces.EnergyAcceptor;
import com.denfop.api.energy.interfaces.EnergyConductor;
import com.denfop.api.energy.interfaces.EnergyController;
import com.denfop.api.energy.interfaces.EnergyEmitter;
import com.denfop.api.energy.interfaces.EnergySink;
import com.denfop.api.energy.interfaces.EnergySource;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.interfaces.MultiDual;
import com.denfop.api.energy.networking.ConductorInfo;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.energy.networking.NodeStats;
import com.denfop.api.energy.networking.Path;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.transport.ITransportTile;
import com.denfop.api.otherenergies.transport.TransportNetGlobal;
import com.denfop.api.otherenergies.transport.event.TransportTileUnLoadEvent;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.network.packet.PacketExplosion;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EnergyNetLocal {
    public static EnergyNetLocal EMPTY = new EnergyNetLocal();
    final EnergyTickList<EnergyTick> energyTickList = new EnergyTickList();
    final List<EnergySource> sourceToUpdateList = new LinkedList<EnergySource>();
    private final List<EnergyController> controllerList;
    private final Map<BlockPos, EnergyTile> chunkCoordinatesIEnergyTileMap;
    private final Map<ChunkPos, List<EnergySink>> chunkPosListMap = new HashMap<ChunkPos, List<EnergySink>>();
    private final List<EnergySource> energySourceList = new ArrayList<EnergySource>();
    private final List<EnergyConductor> conductorsRemove = new LinkedList<EnergyConductor>();
    private final boolean hasrestrictions;
    private final boolean explosing;
    private final boolean ignoring;
    private final boolean losing;
    List<EnergySink> explodeTiles = new ArrayList<EnergySink>();
    private Level world;
    private SunCoef suncoef;
    private int tick;

    EnergyNetLocal(Level world) {
        this.world = world;
        this.controllerList = new ArrayList<EnergyController>();
        this.chunkCoordinatesIEnergyTileMap = new HashMap<BlockPos, EnergyTile>();
        this.tick = 0;
        this.suncoef = new SunCoef(world);
        this.losing = EnergyNetGlobal.instance.getLosing();
        this.ignoring = EnergyNetGlobal.instance.needIgnoringTiers();
        this.explosing = EnergyNetGlobal.instance.needExplosion();
        this.hasrestrictions = EnergyNetGlobal.instance.hasRestrictions();
    }

    EnergyNetLocal() {
        this.world = null;
        this.controllerList = new ArrayList<EnergyController>();
        this.chunkCoordinatesIEnergyTileMap = new HashMap<BlockPos, EnergyTile>();
        this.tick = 0;
        this.suncoef = null;
        this.losing = EnergyNetGlobal.instance.getLosing();
        this.ignoring = EnergyNetGlobal.instance.needIgnoringTiers();
        this.explosing = EnergyNetGlobal.instance.needExplosion();
        this.hasrestrictions = EnergyNetGlobal.instance.hasRestrictions();
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public void explodeTiles(EnergySink sink) {
        if (!(sink instanceof EnergySource)) {
            this.explodeMachineAt(this.getTileFromIEnergy(sink));
            this.removeTile(sink);
        } else {
            this.energySourceList.add((EnergySource)((Object)sink));
        }
    }

    void explodeMachineAt(BlockEntity entity) {
        if (entity == null) {
            return;
        }
        if (this.explosing) {
            EnergyTile energyTile;
            BlockPos pos = entity.m_58899_();
            ITransportTile transportTile = TransportNetGlobal.instance.getSubTile(this.world, pos);
            if (transportTile != null) {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.world, transportTile));
            }
            if (!(entity instanceof BlockEntityBase) && (energyTile = EnergyNetGlobal.instance.getTile(this.world, pos)) != null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.world, energyTile));
            }
            Explosion explosion = new Explosion(this.world, null, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 4.0f, false, Explosion.BlockInteraction.NONE);
            this.world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.world.f_46441_.m_188501_() - this.world.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            this.world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            new PacketExplosion(explosion, 4, false, false);
        }
    }

    public SunCoef getSuncoef() {
        if (this.suncoef == null) {
            this.suncoef = new SunCoef(this.world);
        }
        return this.suncoef;
    }

    public void addController(EnergyController tile1) {
        this.controllerList.add(tile1);
    }

    public void removeController(EnergyController tile1) {
        this.controllerList.remove(tile1);
        tile1.unload();
    }

    public void addTile(EnergyTile tile1) {
        try {
            this.addTileEntity(tile1.getPos(), tile1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addTile(EnergyTile tile, BlockEntity tileentity) {
        try {
            this.addTileEntity(tileentity.m_58899_(), tile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BlockPos getPos(EnergyTile tile) {
        return tile.getPos();
    }

    public Map<ChunkPos, List<EnergySink>> getChunkPosListMap() {
        return this.chunkPosListMap;
    }

    public void addTileEntity(BlockPos coords, EnergyTile tile) {
        if (this.chunkCoordinatesIEnergyTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIEnergyTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof EnergyAcceptor) {
            this.onTileEntityAdded((EnergyAcceptor)tile);
            if (tile instanceof EnergySink) {
                ChunkPos pos = new ChunkPos(tile.getPos());
                List<EnergySink> iEnergySinkList = this.chunkPosListMap.get(pos);
                if (iEnergySinkList == null) {
                    iEnergySinkList = new LinkedList<EnergySink>();
                    iEnergySinkList.add((EnergySink)tile);
                    this.chunkPosListMap.put(pos, iEnergySinkList);
                } else {
                    iEnergySinkList.add((EnergySink)tile);
                }
            }
        }
        if (tile instanceof EnergySource) {
            this.energyTickList.add(new EnergyTick((EnergySource)tile, null));
        }
    }

    private void updateAdd(BlockPos pos, EnergyTile tile) {
        for (Direction dir : Direction.values()) {
            EnergyAcceptor receiver2;
            EnergyEmitter sender2;
            BlockPos pos1 = pos.m_121955_(dir.m_122436_());
            EnergyTile tile1 = this.chunkCoordinatesIEnergyTileMap.get(pos1);
            if (tile1 == EnergyNetGlobal.EMPTY || tile1 == null) continue;
            Direction inverseDirection2 = dir.m_122424_();
            if (tile instanceof Dual) {
                tile1.AddTile(tile, inverseDirection2);
                tile.AddTile(tile1, dir);
                continue;
            }
            if (tile1 instanceof EnergyEmitter && tile instanceof EnergyAcceptor) {
                sender2 = (EnergyEmitter)tile1;
                receiver2 = (EnergyAcceptor)tile;
                if (tile1 instanceof Dual) {
                    tile1.AddTile(tile, inverseDirection2);
                    tile.AddTile(tile1, dir);
                    continue;
                }
                if (!sender2.emitsEnergyTo(receiver2, dir.m_122424_()) || !receiver2.acceptsEnergyFrom(sender2, inverseDirection2.m_122424_())) continue;
                tile1.AddTile(tile, dir.m_122424_());
                tile.AddTile(tile1, dir);
                continue;
            }
            if (!(tile1 instanceof EnergyAcceptor) || !(tile instanceof EnergyEmitter)) continue;
            sender2 = (EnergyEmitter)tile;
            receiver2 = (EnergyAcceptor)tile1;
            if (tile1 instanceof Dual) {
                tile1.AddTile(tile, inverseDirection2);
                tile.AddTile(tile1, dir);
                continue;
            }
            if (!sender2.emitsEnergyTo(receiver2, dir) || !receiver2.acceptsEnergyFrom(sender2, inverseDirection2)) continue;
            tile1.AddTile(tile, dir.m_122424_());
            tile.AddTile(tile1, dir);
        }
    }

    public void removeTile(EnergyTile tile1) {
        if (tile1 != EnergyNetGlobal.EMPTY) {
            this.removeTileEntity(tile1);
        }
    }

    public void removeTileEntity(EnergyTile tile) {
        if (tile.getPos() != null) {
            if (!this.chunkCoordinatesIEnergyTileMap.containsKey(tile.getPos())) {
                return;
            }
        } else {
            return;
        }
        BlockPos coord = tile.getPos();
        this.chunkCoordinatesIEnergyTileMap.remove(coord);
        if (tile instanceof EnergyAcceptor) {
            ChunkPos pos;
            List<EnergySink> iEnergySinkList;
            this.removeAll(this.getSources((EnergyAcceptor)tile));
            if (tile instanceof EnergySink && (iEnergySinkList = this.chunkPosListMap.get(pos = new ChunkPos(tile.getPos()))) != null) {
                iEnergySinkList.remove((EnergySink)tile);
            }
        }
        if (tile instanceof EnergySource) {
            this.remove((EnergySource)tile);
        }
        this.updateRemove(coord, tile);
    }

    private void updateRemove(BlockPos pos, EnergyTile tile) {
        for (Direction dir : Direction.values()) {
            BlockPos pos1 = pos.m_121955_(dir.m_122436_());
            EnergyTile tile1 = this.chunkCoordinatesIEnergyTileMap.get(pos1);
            if (tile1 == EnergyNetGlobal.EMPTY || tile1 == null) continue;
            tile1.RemoveTile(tile, dir.m_122424_());
        }
    }

    public double emitEnergyFrom(EnergySource energySource, double amount, EnergyTick tick) {
        List energyPaths = tick.getList();
        if (energyPaths == null) {
            Tuple<List<Path>, LinkedList<Integer>> triple = this.discover(energySource, tick);
            energyPaths = (List)triple.m_14418_();
            List<Integer> conductors = tick.getConductors();
            if (conductors == null) {
                tick.setConductors((List)triple.m_14419_());
            } else {
                tick.setConductors((List)triple.m_14419_());
            }
            tick.setList(energyPaths);
            tick.rework();
            if (!this.controllerList.isEmpty()) {
                this.controllerList.forEach(EnergyController::work);
            }
        }
        if (amount > 0.0) {
            block0: for (Path energyPath : energyPaths) {
                EnergySink energySink;
                double demandedEnergy;
                if (energySource.canExtractEnergy(energyPath.sourceDirection) <= 0.0 || (demandedEnergy = (energySink = energyPath.target).getDemandedEnergy(energyPath.targetDirection)) <= 0.0) continue;
                double energyProvided = energySource.canExtractEnergy(energyPath.sourceDirection);
                double adding = this.hasrestrictions && !this.explosing ? Math.min(energyProvided, Math.min(demandedEnergy, energyPath.min) + energyPath.loss) : (this.hasrestrictions ? Math.min(energyProvided, demandedEnergy + energyPath.loss) : Math.min(energyProvided, demandedEnergy + energyPath.loss));
                adding -= energyPath.loss;
                if (energyPath.isLimit) {
                    adding = Math.min(adding, energyPath.limit_amount);
                }
                if (adding <= 0.0) continue;
                if (this.ignoring) {
                    int tier = energySink.getSinkTier(energyPath.targetDirection);
                    if (!(energySink instanceof MultiDual)) {
                        int tier1 = EnergyNetGlobal.instance.getTierFromPower(adding);
                        if (tier1 > tier) {
                            if (energyPath.hasController) continue;
                            this.explodeTiles.add(energySink);
                            continue;
                        }
                    } else {
                        int tier1 = energySource.getSourceTier(energyPath.sourceDirection);
                        if (tier1 > tier) {
                            if (energyPath.hasController) continue;
                            this.explodeTiles.add(energySink);
                            continue;
                        }
                    }
                }
                energySink.receiveEnergy(energyPath.targetDirection, adding);
                energyPath.adding = adding;
                energyPath.tick(this.tick, adding);
                energySource.extractEnergy(energyPath.sourceDirection, adding);
                tick.addEnergy(adding);
                amount -= adding;
                amount -= energyPath.loss;
                amount = Math.max(0.0, amount);
                for (ConductorInfo energyConductor : energyPath.getConductorList()) {
                    energyConductor.addEnergy((byte)this.tick, adding);
                    if (!this.hasrestrictions || !this.explosing || !(adding > energyPath.min)) continue;
                    if (!(energyConductor.getBreakdownEnergy() < adding)) continue block0;
                    this.conductorsRemove.add((EnergyConductor)this.getTileEntity(energyConductor.getPos()));
                }
            }
        }
        return amount;
    }

    public double getTotalEnergyEmitted(EnergyTile tileEntity) {
        double ret = 0.0;
        boolean col = false;
        if (tileEntity instanceof EnergyConductor) {
            ret = Math.max(((EnergyConductor)tileEntity).getInfo().getEnergy(this.tick), ret);
            return ret;
        }
        if (tileEntity instanceof EnergySource) {
            EnergySource advEnergySource = (EnergySource)tileEntity;
            if (!(advEnergySource instanceof Dual) && advEnergySource.isSource()) {
                ret = Math.max(0.0, advEnergySource.getPerEnergy() - advEnergySource.getPastEnergy());
            } else if (advEnergySource instanceof Dual && advEnergySource.isSource()) {
                Dual dual = (Dual)advEnergySource;
                ret = Math.max(0.0, dual.getPerEnergy1() - dual.getPastEnergy1());
            }
        }
        return ret;
    }

    public double getTotalEnergySunken(EnergyTile tileEntity) {
        double ret = 0.0;
        boolean col = false;
        if (!(tileEntity instanceof EnergySink)) {
            if (tileEntity instanceof EnergyConductor && tileEntity instanceof EnergyConductor) {
                ret = Math.max(((EnergyConductor)tileEntity).getInfo().getEnergy(this.tick), ret);
                return ret;
            }
        } else {
            EnergySink advEnergySink = (EnergySink)tileEntity;
            if (advEnergySink.isSink() && ((double)(this.tick - 1) == advEnergySink.getTick() || (double)this.tick == advEnergySink.getTick() || (double)(this.tick + 1) == advEnergySink.getTick())) {
                ret = Math.max(0.0, advEnergySink.getPerEnergy() - advEnergySink.getPastEnergy());
            }
        }
        return ret;
    }

    public BlockEntity getTileFromIEnergy(EnergyTile tile) {
        if (tile instanceof BlockEntity) {
            return (BlockEntity)tile;
        }
        return this.world.m_7702_(tile.getPos());
    }

    public Tuple<List<Path>, LinkedList<Integer>> discover(EnergySource emitter, EnergyTick tick) {
        LinkedList<EnergyTile> tileEntitiesToCheck = new LinkedList<EnergyTile>();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList<Integer> set = new LinkedList<Integer>();
        while (!tileEntitiesToCheck.isEmpty()) {
            EnergyTile currentTileEntity = (EnergyTile)tileEntitiesToCheck.pop();
            List<InfoTile<EnergyTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            InfoCable cable = null;
            if (currentTileEntity instanceof EnergyConductor) {
                cable = ((EnergyConductor)currentTileEntity).getCable();
            }
            for (InfoTile<EnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter || ((EnergyTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((EnergyTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof EnergySink) {
                    energyPaths.add(new Path((EnergySink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof EnergyConductor)) continue;
                EnergyConductor conductor = (EnergyConductor)validReceiver.tileEntity;
                conductor.setCable(new InfoCable(conductor, validReceiver.direction, cable));
                tileEntitiesToCheck.push((EnergyTile)validReceiver.tileEntity);
            }
        }
        int id1 = WorldBaseGen.random.nextInt();
        energyPaths = new ArrayList(energyPaths);
        for (Path energyPath : energyPaths) {
            EnergyTile tileEntity = energyPath.target;
            LinkedList<ConductorInfo> pathConductorsList = new LinkedList<ConductorInfo>();
            energyPath.target.getEnergyTickList().add(tick.getSource().hashCode());
            Direction energyBlockLink = energyPath.targetDirection;
            energyPath.sourceDirection = null;
            Direction direction = null;
            tileEntity = tileEntity.getTiles().get(energyBlockLink);
            if (!(tileEntity instanceof EnergyConductor)) continue;
            InfoCable cable = ((EnergyConductor)tileEntity).getCable();
            while (cable != null) {
                EnergyConductor energyConductor = cable.getConductor();
                pathConductorsList.add(energyConductor.getInfo());
                if (energyConductor.getHashCodeSource() != id1) {
                    energyConductor.setHashCodeSource(id1);
                    set.add(energyConductor.hashCode());
                }
                if (energyConductor.getConductorBreakdownEnergy() - 1.0 < energyPath.getMin()) {
                    energyPath.setMin(energyConductor.getConductorBreakdownEnergy() - 1.0);
                }
                if (this.losing) {
                    energyPath.loss += energyConductor.getConductionLoss();
                }
                InfoCable prev = cable;
                if ((cable = cable.getPrev()) != null) continue;
                direction = prev.getConductor().getTiles().entrySet().stream().filter(entry -> entry.getValue() == emitter).map(Map.Entry::getKey).findFirst().orElse(null);
                break;
            }
            if (direction != null) {
                energyPath.sourceDirection = direction.m_122424_();
            }
            energyPath.conductorList = new ArrayList<ConductorInfo>(pathConductorsList);
        }
        return new Tuple((Object)energyPaths, set);
    }

    public List<InfoTile<EnergyTile>> getValidReceivers(EnergyTile emitter) {
        BlockPos tile1 = emitter.getPos();
        if (tile1 != null) {
            if (emitter instanceof Dual) {
                LinkedList<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
                for (InfoTile<EnergyTile> entry : emitter.getValidReceivers()) {
                    EnergyTile target2 = (EnergyTile)entry.tileEntity;
                    if (target2 == emitter || target2 == EnergyNetGlobal.EMPTY) continue;
                    Direction inverseDirection2 = entry.direction;
                    if (target2 instanceof EnergyAcceptor) {
                        EnergyEmitter sender2 = (EnergyEmitter)emitter;
                        EnergyAcceptor receiver2 = (EnergyAcceptor)target2;
                        if (!sender2.emitsEnergyTo(receiver2, inverseDirection2.m_122424_()) || !receiver2.acceptsEnergyFrom(sender2, inverseDirection2)) continue;
                        validReceivers.add(entry);
                        continue;
                    }
                    validReceivers.add(entry);
                }
                return validReceivers;
            }
            LinkedList<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
            for (InfoTile<EnergyTile> entry : emitter.getValidReceivers()) {
                EnergyTile target2 = (EnergyTile)entry.tileEntity;
                if (target2 == emitter || target2 == EnergyNetGlobal.EMPTY) continue;
                Direction inverseDirection2 = entry.direction;
                if (!(!(target2 instanceof EnergyAcceptor) || target2 instanceof EnergyConductor && emitter instanceof EnergyConductor)) {
                    EnergyEmitter sender2 = (EnergyEmitter)emitter;
                    EnergyAcceptor receiver2 = (EnergyAcceptor)target2;
                    if (!sender2.emitsEnergyTo(receiver2, inverseDirection2.m_122424_()) || !receiver2.acceptsEnergyFrom(sender2, inverseDirection2)) continue;
                    validReceivers.add(entry);
                    continue;
                }
                validReceivers.add(entry);
            }
            return validReceivers;
        }
        return Collections.emptyList();
    }

    public void remove1(EnergySource par1) {
        for (EnergyTick ticks : this.energyTickList) {
            if (ticks.getSource() != par1) continue;
            if (ticks.getList() != null) {
                for (Path path : ticks.getList()) {
                    path.target.getEnergyTickList().remove((Object)ticks.getSource().hashCode());
                }
            }
            ticks.setList(null);
            break;
        }
    }

    public void remove(EnergySource par1) {
        EnergyTick energyTick = this.energyTickList.removeSource(par1);
        if (energyTick != null && energyTick.getList() != null) {
            for (Path path : energyTick.getList()) {
                path.target.getEnergyTickList().remove((Object)energyTick.hashCode());
            }
        }
    }

    public void removeAll(List<EnergyTick> par1) {
        if (par1 == null) {
            return;
        }
        for (EnergyTick IEnergySource : par1) {
            if (IEnergySource.getList() != null) {
                for (Path path : IEnergySource.getList()) {
                    path.target.getEnergyTickList().remove((Object)IEnergySource.hashCode());
                }
                IEnergySource.conductors.clear();
            }
            IEnergySource.setList(null);
        }
    }

    public List<Path> getPaths(EnergyAcceptor par1) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (par1 instanceof EnergyConductor) {
            block0: for (EnergyTick tick : this.energyTickList) {
                List<Path> paths1 = tick.getList();
                if (paths1 == null) continue;
                for (Path path : paths1) {
                    if (!path.getConductorList().contains(((EnergyConductor)par1).getInfo())) continue;
                    paths.add(path);
                    continue block0;
                }
            }
            return paths;
        }
        List<EnergyTick> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (EnergyTick source : sources_list) {
            paths.addAll(source.getList());
        }
        return paths;
    }

    public List<EnergyTick> getSources(EnergyAcceptor par1) {
        if (par1 instanceof EnergySink) {
            LinkedList<EnergyTick> list = new LinkedList<EnergyTick>();
            for (EnergyTick energyTicks : this.energyTickList) {
                if (!((EnergySink)par1).getEnergyTickList().contains(energyTicks.getSource().hashCode())) continue;
                list.add(energyTicks);
            }
            return list;
        }
        if (par1 instanceof EnergyConductor) {
            LinkedList<EnergyTick> list = new LinkedList<EnergyTick>();
            for (EnergyTick energyTicks : this.energyTickList) {
                if (!energyTicks.conductors.contains(par1.hashCode())) continue;
                list.add(energyTicks);
            }
            return new ArrayList<EnergyTick>(list);
        }
        return Collections.emptyList();
    }

    public void clear() {
        this.energyTickList.clear();
    }

    public List<InfoTile<EnergyTile>> getValidReceiversSubstitute(EnergyTile emitter) {
        BlockPos tile1 = emitter.getPos();
        if (tile1 != null) {
            if (emitter instanceof Dual) {
                LinkedList<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
                for (InfoTile<EnergyTile> entry : emitter.getValidReceivers()) {
                    EnergyTile target2 = (EnergyTile)entry.tileEntity;
                    if (target2 == emitter || target2 == EnergyNetGlobal.EMPTY) continue;
                    Direction inverseDirection2 = entry.direction;
                    if (target2 instanceof EnergyAcceptor) {
                        EnergyEmitter sender2 = (EnergyEmitter)emitter;
                        EnergyAcceptor receiver2 = (EnergyAcceptor)target2;
                        if (!sender2.emitsEnergyTo(receiver2, inverseDirection2.m_122424_()) || !receiver2.acceptsEnergyFrom(sender2, inverseDirection2)) continue;
                        validReceivers.add(entry);
                        continue;
                    }
                    validReceivers.add(entry);
                }
                return validReceivers;
            }
            return emitter.getValidReceivers();
        }
        return Collections.emptyList();
    }

    public void onTickEnd() {
        for (EnergySource source : this.energySourceList) {
            this.removeTile(source);
            this.explodeMachineAt(this.getTileFromIEnergy(source));
        }
        for (EnergyConductor conductor : this.conductorsRemove) {
            BlockEntityBase tile = (BlockEntityBase)((Object)conductor);
            tile.onUnloaded();
            this.world.m_7471_(conductor.getPos(), false);
        }
        this.conductorsRemove.clear();
        this.energySourceList.clear();
        if (this.suncoef == null) {
            this.suncoef = new SunCoef(this.world);
        }
        this.suncoef.calculate();
        if (!this.sourceToUpdateList.isEmpty()) {
            for (EnergySource source : this.sourceToUpdateList) {
                this.remove1(source);
            }
            this.sourceToUpdateList.clear();
        }
        for (EnergyTick tick : new ArrayList<EnergyTick>(this.energyTickList)) {
            EnergySource entry = tick.getSource();
            tick.tick();
            if (entry.isRemovedTile()) {
                this.sourceToUpdateList.add(entry);
                continue;
            }
            if (tick.getList() != null && tick.getList().isEmpty()) continue;
            int multi = entry instanceof MultiDual ? 4 : 1;
            for (int k = 0; k < multi; ++k) {
                double offer = Math.min(entry.canExtractEnergy(), EnergyNetGlobal.instance.getPowerFromTier(entry.getSourceTier()));
                if (offer > 0.0) {
                    this.emitEnergyFrom(entry, offer, tick);
                    continue;
                }
                if (!tick.isAdv() || !tick.getAdvSource().isSource()) continue;
                tick.getAdvSource().setPastEnergy(tick.getAdvSource().getPerEnergy());
            }
        }
        for (EnergySink sink : this.explodeTiles) {
            this.explodeTiles(sink);
        }
        this.explodeTiles.clear();
        ++this.tick;
        if (this.tick > 100) {
            this.tick = 0;
        }
    }

    public EnergyTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesIEnergyTileMap.getOrDefault(pos, EnergyNetGlobal.EMPTY);
    }

    public NodeStats getNodeStats(EnergyTile tile) {
        double emitted = this.getTotalEnergyEmitted(tile);
        double received = this.getTotalEnergySunken(tile);
        return new NodeStats(received, emitted);
    }

    public List<Path> getEnergyPaths(EnergyTile energyTile) {
        ArrayList<Path> energyPathList = new ArrayList<Path>();
        if (energyTile instanceof EnergySource) {
            return energyPathList;
        }
        if (energyTile instanceof EnergyConductor) {
            return this.getPaths((EnergyAcceptor)energyTile);
        }
        return energyPathList;
    }

    public Map<BlockPos, EnergyTile> getChunkCoordinatesIEnergyTileMap() {
        return this.chunkCoordinatesIEnergyTileMap;
    }

    public void onUnload() {
        this.energyTickList.clear();
        this.chunkCoordinatesIEnergyTileMap.clear();
        this.controllerList.clear();
        this.suncoef = null;
    }

    public void onTileEntityAdded(EnergyAcceptor tile) {
        LinkedList<EnergyTile> tileEntitiesToCheck = new LinkedList<EnergyTile>();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        while (!tileEntitiesToCheck.isEmpty()) {
            EnergyTile currentTileEntity = (EnergyTile)tileEntitiesToCheck.pop();
            List<InfoTile<EnergyTile>> validReceivers = currentTileEntity.getValidReceivers();
            for (InfoTile<EnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((EnergyTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((EnergyTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof EnergySource) {
                    this.sourceToUpdateList.add((EnergySource)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof EnergyConductor)) continue;
                tileEntitiesToCheck.push((EnergyTile)validReceiver.tileEntity);
            }
        }
    }

    private void removeTile(BlockPos coord) {
        EnergyTile tile = this.chunkCoordinatesIEnergyTileMap.remove(coord);
        if (tile != null) {
            this.updateRemove(coord, tile);
        }
    }

    public void onTileEntityRemoved(EnergyAcceptor par1) {
        this.onTileEntityAdded(par1);
    }
}

