/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.guidebook;

import com.denfop.IUCore;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.GuideTab;
import com.denfop.api.guidebook.Shape;
import com.denfop.api.guidebook.TypeObject;
import com.denfop.api.guidebook.TypeQuest;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class Quest {
    private final boolean itemInform;
    public Shape prevShape;
    public ItemStack icon;
    public boolean hasPrev = false;
    public String unLocalizedName;
    public Shape shape;
    public TypeQuest typeQuest;
    public TypeObject typeObject;
    public List<ItemStack> itemStacks;
    public List<FluidStack> fluidStacks;
    public String prevName;
    public int prevX;
    public int prevY;
    public int x;
    public int y;
    private String localizedName;
    private String localizedDescription;

    private Quest(int x, int y, String unLocalizedName, String unLocalizedDescription, Shape shape, TypeQuest typeQuest, TypeObject typeObject, List<ItemStack> itemStacks, List<FluidStack> fluidStacks, GuideTab guideTab, String prev, ItemStack icon, boolean localizationItem, boolean itemInform, boolean noDescription) {
        this.x = x;
        this.y = y;
        this.unLocalizedName = unLocalizedName;
        this.localizedName = unLocalizedName;
        this.localizedDescription = unLocalizedDescription;
        if (noDescription) {
            this.localizedDescription = "";
        }
        this.shape = shape;
        this.typeQuest = typeQuest;
        this.itemInform = itemInform;
        this.fluidStacks = Collections.unmodifiableList(fluidStacks);
        this.itemStacks = Collections.unmodifiableList(itemStacks);
        this.typeObject = typeObject;
        GuideBookCore.instance.addQuestToTab(this, guideTab);
        if (!prev.isEmpty()) {
            Quest prevQuest = GuideBookCore.instance.getPrev("iu.guide_quest_name." + prev, guideTab);
            this.prevX = prevQuest.x;
            this.prevY = prevQuest.y;
            this.hasPrev = true;
            this.prevName = prevQuest.unLocalizedName;
            this.prevShape = prevQuest.shape;
        }
        this.icon = icon;
        if (this.icon == null) {
            this.icon = !this.itemStacks.isEmpty() ? this.itemStacks.get(0) : (!this.fluidStacks.isEmpty() ? ModUtils.getCellFromFluid(this.fluidStacks.get(0).getFluid()) : new ItemStack((ItemLike)Blocks.f_50652_));
        }
        if (localizationItem) {
            this.localizedName = this.icon.m_41778_();
            if (itemStacks.isEmpty() && !fluidStacks.isEmpty()) {
                this.localizedName = fluidStacks.get(0).getTranslationKey();
            }
        }
    }

    public String getLocalizedName() {
        return Localization.translate(this.localizedName);
    }

    public String getLocalizedDescription() {
        if (this.itemInform && IUCore.network.getClient() != null) {
            return this.getLocalization(this.icon);
        }
        return Localization.translate(this.localizedDescription);
    }

    @OnlyIn(value=Dist.CLIENT)
    private String getLocalization(ItemStack icon) {
        ArrayList information = new ArrayList();
        icon.m_41720_().m_7373_(icon, (Level)Minecraft.m_91087_().f_91073_, information, () -> false);
        AtomicReference<String> result = new AtomicReference<String>("");
        information.forEach(informations -> result.set((String)result.get() + informations.getString().replace("[", "").replace("]", "") + " "));
        return result.get();
    }

    public static final class Builder {
        List<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        private String unLocalizedName = "";
        private Shape shape = Shape.DEFAULT;
        private TypeQuest typeQuest = TypeQuest.DETECT;
        private TypeObject typeObject = TypeObject.FLUID_ITEM;
        private GuideTab guideTab;
        private String unLocalizedDescription;
        private String prev;
        private int x;
        private int y;
        private ItemStack icon;
        private boolean localizationItem;
        private boolean itemInform;
        private boolean noDescription;

        public Builder() {
            this.guideTab = GuideBookCore.instance.guideTabs.get(0);
            this.unLocalizedDescription = "";
            this.prev = "";
            this.localizationItem = false;
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(String name) {
            return new Builder().name(name);
        }

        public Builder name(String unLocalizedName) {
            this.unLocalizedName = "iu.guide_quest_name." + unLocalizedName;
            this.description(unLocalizedName);
            return this;
        }

        public Builder localizationItem() {
            this.localizationItem = true;
            return this;
        }

        public Builder noDescription() {
            this.noDescription = true;
            return this;
        }

        public Builder useItemInform() {
            this.itemInform = true;
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        public Builder icon(ItemStack icon) {
            this.icon = icon;
            return this;
        }

        public Builder quest(TypeQuest typeQuest) {
            this.typeQuest = typeQuest;
            return this;
        }

        public Builder type(TypeObject typeObject) {
            this.typeObject = typeObject;
            return this;
        }

        public Builder itemStack(ItemStack itemStack) {
            if (this.typeObject.isItem()) {
                this.itemStacks.add(itemStack);
            }
            return this;
        }

        public Builder fluidStack(FluidStack fluidStack) {
            if (this.typeObject.isFluid()) {
                this.fluidStacks.add(fluidStack);
            }
            return this;
        }

        public Builder itemStack(ItemStack ... itemStack) {
            if (this.typeObject.isItem()) {
                this.itemStacks.addAll(Arrays.asList(itemStack));
            }
            return this;
        }

        public Builder fluidStack(FluidStack ... fluidStack) {
            if (this.typeObject.isFluid()) {
                this.fluidStacks.addAll(Arrays.asList(fluidStack));
            }
            return this;
        }

        public Builder itemStack(List<ItemStack> itemStack) {
            if (this.typeObject.isItem()) {
                this.itemStacks.addAll(itemStack);
            }
            return this;
        }

        public Builder fluidStack(List<FluidStack> fluidStack) {
            if (this.typeObject.isFluid()) {
                this.fluidStacks.addAll(fluidStack);
            }
            return this;
        }

        public Builder tab(GuideTab guideTab) {
            this.guideTab = guideTab;
            return this;
        }

        public Builder description(String unLocalizedDescription) {
            this.unLocalizedDescription = "iu.guide_quest_description." + unLocalizedDescription;
            return this;
        }

        public Builder prev(String prev) {
            this.prev = prev;
            return this;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public void build() {
            new Quest(this.x, this.y, this.unLocalizedName, this.unLocalizedDescription, this.shape, this.typeQuest, this.typeObject, this.itemStacks, this.fluidStacks, this.guideTab, this.prev, this.icon, this.localizationItem, this.itemInform, this.noDescription);
        }
    }
}

