/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.otherenergies.common.networking;

import com.denfop.api.energy.SystemTick;
import com.denfop.api.energy.networking.ConductorInfo;
import com.denfop.api.energy.networking.NodeStats;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.otherenergies.common.InfoCable;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.common.interfaces.Acceptor;
import com.denfop.api.otherenergies.common.interfaces.Conductor;
import com.denfop.api.otherenergies.common.interfaces.Dual;
import com.denfop.api.otherenergies.common.interfaces.Emitter;
import com.denfop.api.otherenergies.common.interfaces.Sink;
import com.denfop.api.otherenergies.common.interfaces.Source;
import com.denfop.api.otherenergies.common.interfaces.Tile;
import com.denfop.api.otherenergies.common.networking.Path;
import com.denfop.api.otherenergies.common.networking.SystemTickList;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;

public class LocalNet
implements com.denfop.api.otherenergies.common.interfaces.LocalNet {
    final SystemTickList<SystemTick<Source, Path>> senderPath = new SystemTickList();
    private final Map<BlockPos, Tile> chunkCoordinatesTileMap;
    private final EnergyType energyType;
    List<Source> sourceToUpdateList = new ArrayList<Source>();
    private int tick;

    public LocalNet(EnergyType energyType) {
        this.energyType = energyType;
        this.chunkCoordinatesTileMap = new HashMap<BlockPos, Tile>();
        this.tick = 0;
    }

    public void put(Source par1, List<Path> par2) {
        this.senderPath.add(new SystemTick<Source, Path>(par1, par2));
    }

    public boolean containsKey(SystemTick<Source, Path> par1) {
        return this.senderPath.contains(par1);
    }

    public boolean containsKey(Source par1) {
        return this.senderPath.contains(new SystemTick(par1, null));
    }

    public void remove1(Source par1) {
        for (SystemTick systemTick : this.senderPath) {
            if (systemTick.getSource() != par1) continue;
            if (systemTick.getList() != null) {
                for (Path path : systemTick.getList()) {
                    path.target.getEnergyTickList().remove(systemTick.getSource());
                }
            }
            systemTick.setList(null);
            break;
        }
    }

    public void remove(Source par1) {
        SystemTick<Source, Path> energyTick = this.senderPath.removeSource(par1);
        if (energyTick != null && energyTick.getList() != null) {
            for (Path path : energyTick.getList()) {
                path.target.getEnergyTickList().remove(energyTick.getSource());
            }
        }
    }

    public void removeAll(List<SystemTick<Source, Path>> par1) {
        if (par1 == null) {
            return;
        }
        for (SystemTick<Source, Path> IEnergySource : par1) {
            if (IEnergySource.getList() != null) {
                for (Path path : IEnergySource.getList()) {
                    path.target.getEnergyTickList().remove(IEnergySource.getSource());
                }
            }
            IEnergySource.setList(null);
        }
    }

    @Override
    public List<Path> getPaths(Acceptor par1) {
        ArrayList<Path> paths = new ArrayList<Path>();
        List<SystemTick<Source, Path>> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (SystemTick<Source, Path> source : sources_list) {
            paths.addAll(source.getList());
        }
        return paths;
    }

    public List<SystemTick<Source, Path>> getSources(Acceptor par1) {
        if (par1 instanceof Sink) {
            LinkedList<SystemTick<Source, Path>> list = new LinkedList<SystemTick<Source, Path>>();
            for (SystemTick systemTick : this.senderPath) {
                if (!((Sink)par1).getEnergyTickList().contains(systemTick.getSource())) continue;
                list.add(systemTick);
            }
            return list;
        }
        if (par1 instanceof Conductor) {
            LinkedList<SystemTick> list = new LinkedList<SystemTick>();
            for (SystemTick systemTick : this.senderPath) {
                if (!systemTick.getConductors().contains(par1)) continue;
                list.add(systemTick);
            }
            return new ArrayList<SystemTick<Source, Path>>(list);
        }
        return Collections.emptyList();
    }

    public void clear() {
        this.senderPath.clear();
    }

    public SystemTick<Source, Path> get(Source tileEntity) {
        for (SystemTick systemTick : this.senderPath) {
            if (systemTick.getSource() != tileEntity) continue;
            return systemTick;
        }
        return null;
    }

    public double emitEnergyFrom(Source energySource, double amount, SystemTick<Source, Path> tick) {
        List energyPaths = tick.getList();
        if (energyPaths == null) {
            Tuple<List<Path>, LinkedList<Conductor>> tuples = this.discover(energySource, tick);
            energyPaths = (List)tuples.m_14418_();
            LinkedList<Conductor> conductors = tick.getConductors();
            if (conductors == null) {
                tick.setConductors((LinkedList)tuples.m_14419_());
            } else {
                tick.setConductors((LinkedList)tuples.m_14419_());
            }
            tick.setList(energyPaths);
        }
        if (!(energySource instanceof Dual) && energySource.isSource()) {
            energySource.setPastEnergy(energySource.getPerEnergy());
        } else if (energySource instanceof Dual && energySource.isSource()) {
            ((Dual)energySource).setPastEnergy1(((Dual)energySource).getPerEnergy1());
        }
        if (amount > 0.0) {
            for (Path energyPath : energyPaths) {
                if (amount <= 0.0) break;
                Sink energySink = energyPath.target;
                double demandedEnergy = energySink.getDemanded();
                if (demandedEnergy <= 0.0) continue;
                double energyProvided = Math.min(demandedEnergy, amount);
                energySink.receivedEnergy(energyProvided);
                if (!(energySource instanceof Dual) && energySource.isSource()) {
                    energySource.addPerEnergy(energyProvided);
                } else if (energySource instanceof Dual && energySource.isSource()) {
                    ((Dual)energySource).addPerEnergy1(energyProvided);
                }
                energyPath.tick(this.tick, energyProvided);
                if (this.energyType.isDraw()) {
                    amount -= energyProvided;
                    amount = Math.max(0.0, amount);
                }
                for (ConductorInfo energyConductor : energyPath.conductorList) {
                    energyConductor.addEnergy((byte)this.tick, energyProvided);
                }
            }
        }
        return amount;
    }

    @Override
    public void TickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (Source source : this.sourceToUpdateList) {
                this.remove1(source);
            }
            this.sourceToUpdateList.clear();
        }
        for (SystemTick systemTick : this.senderPath) {
            double offer;
            Source entry = (Source)systemTick.getSource();
            if (systemTick.getList() != null && systemTick.getList().isEmpty() || entry == null) continue;
            if (entry.isSource()) {
                if (entry instanceof Dual) {
                    ((Dual)entry).setPastEnergy1(((Dual)entry).getPastEnergy1());
                } else {
                    entry.setPastEnergy(entry.getPerEnergy());
                }
            }
            if ((offer = entry.canProvideEnergy()) > 0.0) {
                double removed = offer - this.emitEnergyFrom(entry, offer, systemTick);
                if (!this.energyType.isDraw()) continue;
                entry.extractEnergy(removed);
                continue;
            }
            if (!entry.isSource()) continue;
            if (entry instanceof Dual) {
                ((Dual)entry).setPastEnergy1(((Dual)entry).getPastEnergy1());
                continue;
            }
            entry.setPastEnergy(entry.getPerEnergy());
        }
        ++this.tick;
    }

    public double getTotalEmitted(Tile tileEntity) {
        double ret = 0.0;
        boolean col = false;
        if (tileEntity instanceof Conductor) {
            ret = Math.max(((Conductor)tileEntity).getInfo(this.energyType).getEnergy(this.tick), ret);
            return ret;
        }
        if (tileEntity instanceof Source) {
            Source advEnergySource = (Source)tileEntity;
            if (!(advEnergySource instanceof Dual) && advEnergySource.isSource()) {
                ret = Math.max(0.0, advEnergySource.getPerEnergy() - advEnergySource.getPastEnergy());
            } else if (advEnergySource instanceof Dual && advEnergySource.isSource()) {
                Dual dual = (Dual)advEnergySource;
                ret = Math.max(0.0, dual.getPerEnergy1() - dual.getPastEnergy1());
            }
        }
        return !col ? ret : ret / (double)col;
    }

    public double getTotalAccepted(Tile tileEntity) {
        Sink advEnergySink;
        double ret = 0.0;
        if (tileEntity instanceof Conductor) {
            ret = Math.max(((Conductor)tileEntity).getInfo(this.energyType).getEnergy(this.tick), ret);
            return ret;
        }
        if (tileEntity instanceof Sink && (advEnergySink = (Sink)tileEntity).isSink() && ((double)(this.tick - 1) == advEnergySink.getTick() || (double)this.tick == advEnergySink.getTick() || (double)(this.tick + 1) == advEnergySink.getTick())) {
            ret = Math.max(0.0, advEnergySink.getPerEnergy() - advEnergySink.getPastEnergy());
        }
        return ret;
    }

    @Override
    public NodeStats getNodeStats(Tile tile) {
        double emitted = this.getTotalEmitted(tile);
        double received = this.getTotalAccepted(tile);
        return new NodeStats(received, emitted);
    }

    @Override
    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesTileMap.clear();
    }

    @Override
    public Tile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesTileMap.get(pos);
    }

    @Override
    public void addTile(Tile tile1) {
        this.addTileEntity(tile1.getPos(), tile1);
    }

    @Override
    public void removeTile(Tile tile1) {
        this.removeTileEntity(tile1);
    }

    private void updateRemove(BlockPos pos, Tile tile) {
        for (Direction dir : Direction.values()) {
            BlockPos pos1 = pos.m_121955_(dir.m_122436_());
            Tile tile1 = this.chunkCoordinatesTileMap.get(pos1);
            if (tile1 == null) continue;
            tile1.RemoveTile(this.energyType, tile, dir.m_122424_());
        }
    }

    public void removeTileEntity(Tile tile) {
        if (!this.chunkCoordinatesTileMap.containsKey(tile.getPos())) {
            return;
        }
        BlockPos coord = tile.getPos();
        this.chunkCoordinatesTileMap.remove(coord);
        if (tile instanceof Acceptor) {
            this.removeAll(this.getSources((Acceptor)tile));
        }
        if (tile instanceof Source) {
            this.remove((Source)tile);
        }
        this.updateRemove(coord, tile);
    }

    public Tuple<List<Path>, LinkedList<Conductor>> discover(Source emitter, SystemTick<Source, Path> tick) {
        LinkedList<Tile> tileEntitiesToCheck = new LinkedList<Tile>();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList<Conductor> set = new LinkedList<Conductor>();
        while (!tileEntitiesToCheck.isEmpty()) {
            Tile currentTileEntity = (Tile)tileEntitiesToCheck.pop();
            List<InfoTile<Tile>> validReceivers = this.getValidReceivers(currentTileEntity);
            InfoCable cable = null;
            if (currentTileEntity instanceof Conductor) {
                cable = ((Conductor)currentTileEntity).getCable(this.energyType);
            }
            for (InfoTile<Tile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter || ((Tile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((Tile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof Sink) {
                    energyPaths.add(new Path((Sink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof Conductor)) continue;
                Conductor conductor = (Conductor)validReceiver.tileEntity;
                conductor.setCable(this.energyType, new InfoCable(conductor, validReceiver.direction, cable));
                tileEntitiesToCheck.push((Tile)validReceiver.tileEntity);
            }
        }
        int id1 = WorldBaseGen.random.nextInt();
        energyPaths = new ArrayList(energyPaths);
        for (Path energyPath : energyPaths) {
            Tile tileEntity = energyPath.target;
            LinkedList<ConductorInfo> pathConductorsList = new LinkedList<ConductorInfo>();
            energyPath.target.getEnergyTickList().add(tick.getSource());
            Direction energyBlockLink = energyPath.targetDirection;
            tileEntity = tileEntity.getTiles(this.energyType).get(energyBlockLink);
            if (!(tileEntity instanceof Conductor)) continue;
            InfoCable cable = ((Conductor)tileEntity).getCable(this.energyType);
            while (cable != null) {
                Conductor energyConductor = cable.getConductor();
                pathConductorsList.add(energyConductor.getInfo(this.energyType));
                if (energyConductor.getHashCodeSource() != id1) {
                    energyConductor.setHashCodeSource(id1);
                    set.add(energyConductor);
                }
                if ((cable = cable.getPrev()) != null) continue;
                break;
            }
            energyPath.conductorList = new ArrayList(pathConductorsList);
        }
        return new Tuple((Object)energyPaths, set);
    }

    public List<InfoTile<Tile>> getValidReceivers(Tile emitter) {
        BlockPos tile1 = emitter.getPos();
        if (tile1 != null) {
            if (emitter instanceof Dual) {
                LinkedList<InfoTile<Tile>> validReceivers = new LinkedList<InfoTile<Tile>>();
                for (InfoTile<Tile> entry : emitter.getValidReceivers(this.energyType)) {
                    Tile target2 = (Tile)entry.tileEntity;
                    if (target2 == emitter || target2 == null) continue;
                    Direction inverseDirection2 = entry.direction;
                    if (target2 instanceof Acceptor) {
                        Emitter sender2 = (Emitter)emitter;
                        Acceptor receiver2 = (Acceptor)target2;
                        if (!sender2.emitsTo(receiver2, inverseDirection2.m_122424_()) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
                        validReceivers.add(entry);
                        continue;
                    }
                    validReceivers.add(entry);
                }
                return validReceivers;
            }
            LinkedList<InfoTile<Tile>> validReceivers = new LinkedList<InfoTile<Tile>>();
            for (InfoTile<Tile> entry : emitter.getValidReceivers(this.energyType)) {
                Tile target2 = (Tile)entry.tileEntity;
                if (target2 == emitter || target2 == null) continue;
                Direction inverseDirection2 = entry.direction;
                if (!(!(target2 instanceof Acceptor) || target2 instanceof Conductor && emitter instanceof Conductor)) {
                    Emitter sender2 = (Emitter)emitter;
                    Acceptor receiver2 = (Acceptor)target2;
                    if (!sender2.emitsTo(receiver2, inverseDirection2.m_122424_()) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
                    validReceivers.add(entry);
                    continue;
                }
                validReceivers.add(entry);
            }
            return validReceivers;
        }
        return Collections.emptyList();
    }

    public void addTileEntity(BlockPos coords, Tile tile) {
        if (this.chunkCoordinatesTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof Acceptor) {
            this.onTileEntityAdded((Acceptor)tile);
        }
        if (tile instanceof Source) {
            this.senderPath.add(new SystemTick((Source)tile, null));
        }
    }

    private void updateAdd(BlockPos pos, Tile tile) {
        for (Direction dir : Direction.values()) {
            Acceptor receiver2;
            Emitter sender2;
            BlockPos pos1 = pos.m_121955_(dir.m_122436_());
            Tile tile1 = this.chunkCoordinatesTileMap.get(pos1);
            if (tile1 == null) continue;
            Direction inverseDirection2 = dir.m_122424_();
            if (tile instanceof Dual) {
                tile1.AddTile(this.energyType, tile, inverseDirection2);
                tile.AddTile(this.energyType, tile1, dir);
                continue;
            }
            if (tile1 instanceof Emitter && tile instanceof Acceptor) {
                sender2 = (Emitter)tile1;
                receiver2 = (Acceptor)tile;
                if (tile1 instanceof Dual) {
                    tile1.AddTile(this.energyType, tile, inverseDirection2);
                    tile.AddTile(this.energyType, tile1, dir);
                    continue;
                }
                if (!sender2.emitsTo(receiver2, dir.m_122424_()) || !receiver2.acceptsFrom(sender2, inverseDirection2.m_122424_())) continue;
                tile1.AddTile(this.energyType, tile, dir.m_122424_());
                tile.AddTile(this.energyType, tile1, dir);
                continue;
            }
            if (!(tile1 instanceof Acceptor) || !(tile instanceof Emitter)) continue;
            sender2 = (Emitter)tile;
            receiver2 = (Acceptor)tile1;
            if (tile1 instanceof Dual) {
                tile1.AddTile(this.energyType, tile, inverseDirection2);
                tile.AddTile(this.energyType, tile1, dir);
                continue;
            }
            if (!sender2.emitsTo(receiver2, dir) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
            tile1.AddTile(this.energyType, tile, dir.m_122424_());
            tile.AddTile(this.energyType, tile1, dir);
        }
    }

    public void onTileEntityAdded(Acceptor tile) {
        LinkedList<Tile> tileEntitiesToCheck = new LinkedList<Tile>();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        this.sourceToUpdateList = new LinkedList<Source>();
        while (!tileEntitiesToCheck.isEmpty()) {
            Tile currentTileEntity = (Tile)tileEntitiesToCheck.pop();
            List<InfoTile<Tile>> validReceivers = currentTileEntity.getValidReceivers(this.energyType);
            for (InfoTile<Tile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((Tile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((Tile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof Source) {
                    this.sourceToUpdateList.add((Source)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof Conductor)) continue;
                tileEntitiesToCheck.push((Tile)validReceiver.tileEntity);
            }
        }
        this.sourceToUpdateList = new ArrayList<Source>(this.sourceToUpdateList);
    }
}

