/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.item.DamageItem;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.LogicCreativeReactor;
import com.denfop.items.reactors.ItemComponentVent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;

public class LogicCreativeComponent {
    private final IReactorItem item;
    private final ItemStack stack;
    private final IAdvReactor reactor;
    private final boolean componentVent;
    private final int x;
    private final int y;
    public int nearRod = 0;
    public int damage;
    double heat;
    private int maxDamage = 0;
    private int damageItem;
    private int count;
    private List<LogicCreativeComponent> logicComponents;

    public LogicCreativeComponent(IReactorItem item, int x, int y, ItemStack stack, IAdvReactor reactor) {
        this.item = item;
        this.x = x;
        this.y = y;
        this.logicComponents = new ArrayList<LogicCreativeComponent>(Collections.nCopies(4, LogicCreativeReactor.NULL));
        this.heat = item.getHeat(reactor);
        if (item.getType() == EnumTypeComponent.ROD) {
            this.damage = 1;
        }
        this.stack = stack;
        this.count = 0;
        this.reactor = reactor;
        this.componentVent = this.stack.m_41720_() instanceof ItemComponentVent;
        if (stack.m_41720_() instanceof DamageItem) {
            this.maxDamage = ((DamageItem)stack.m_41720_()).getMaxCustomDamage(stack);
        }
        this.damageItem = this.maxDamage;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public List<LogicCreativeComponent> getLogicComponents() {
        return this.logicComponents;
    }

    public IReactorItem getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicCreativeComponent that = (LogicCreativeComponent)o;
        return this.x == that.x && this.y == that.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public void updateAllInterface(List<LogicCreativeComponent> logicComponents, int width, int height, IAdvReactor reactor) {
        double temp_heat;
        LogicCreativeComponent cmp;
        if (this.x == -1 || this.y == -1) {
            return;
        }
        int i = -1;
        int k = 0;
        while (i <= 1) {
            if (this.x + i < 0 || this.x + i >= width) {
                ++this.count;
            } else {
                if (this.getItem().getType() == EnumTypeComponent.ROD) {
                    this.heat *= reactor.getMulHeatRod(this.x, this.y, this.stack);
                }
                if ((cmp = logicComponents.get(this.x + i + width * this.y)).getItem() != null && cmp.x != -1) {
                    this.logicComponents.set(k, cmp);
                    if (this.getItem().getType() == EnumTypeComponent.ROD && cmp.getItem().getType() == EnumTypeComponent.ROD) {
                        temp_heat = this.heat;
                        this.heat += cmp.heat / 4.0;
                        cmp.heat += temp_heat / 4.0;
                    }
                }
                if (cmp.equals(LogicCreativeReactor.NULL)) {
                    ++this.count;
                }
            }
            i += 2;
            ++k;
        }
        int j = -1;
        k = 2;
        while (j <= 1) {
            if (this.y + j < 0 || this.y + j >= height) {
                ++this.count;
            } else {
                cmp = logicComponents.get(this.x + width * (this.y + j));
                if (cmp.getItem() != null) {
                    this.logicComponents.set(k, cmp);
                    if (this.getItem().getType() == EnumTypeComponent.ROD && cmp.getItem().getType() == EnumTypeComponent.ROD) {
                        temp_heat = this.heat;
                        this.heat += cmp.heat / 4.0;
                        cmp.heat += temp_heat / 4.0;
                    }
                }
                if (cmp.equals(LogicCreativeReactor.NULL)) {
                    ++this.count;
                }
                if (this.getItem().getType() == EnumTypeComponent.ROD && this.count != 0) {
                    this.heat *= (double)(this.count + 1) * 1.5;
                }
            }
            j += 2;
            ++k;
        }
        this.logicComponents.removeIf(logicComponent -> logicComponent.x == -1);
    }

    public boolean canExtractHeat() {
        return this.getItem().caneExtractHeat();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void calculateDamageOther() {
        if (this.getItem().getRepairOther(this.reactor) > 0) {
            for (LogicCreativeComponent component : this.logicComponents) {
                component.damage -= this.getItem().getRepairOther(this.reactor);
            }
        }
    }

    public boolean onTick() {
        if (this.getItem().getType() == EnumTypeComponent.ROD) {
            return false;
        }
        if (this.componentVent) {
            if (this.damage > 150 * this.getItem().getLevel()) {
                this.damageItem = 0;
            }
        } else {
            this.damageItem -= this.damage;
            if (this.damageItem > this.maxDamage) {
                this.damageItem = this.maxDamage;
            }
            ((DamageItem)this.stack.m_41720_()).setCustomDamage(this.stack, this.maxDamage - this.damageItem);
        }
        if (this.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
            double heat = this.reactor.getHeat();
            heat -= this.heat;
            heat = Math.max(0.0, heat);
            this.reactor.setHeat(heat);
        }
        return this.damageItem <= 0;
    }

    public double getHeat() {
        if (this.getItem().getType() == EnumTypeComponent.CAPACITOR || this.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
            return 0.0;
        }
        return this.heat;
    }
}

