/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.CreativeReactor;
import com.denfop.api.reactors.LogicCreativeComponent;
import com.denfop.api.reactors.LogicCreativeReactor;
import java.util.HashMap;
import java.util.Map;

public class LogicCreativeGraphiteReactor
extends LogicCreativeReactor {
    public double temp_heat = 0.0;
    public int[] coolant = new int[]{2, 3, 4, 4};
    Map<Integer, Double> mapGraphiteConsume;

    public LogicCreativeGraphiteReactor(CreativeReactor advReactor) {
        super(advReactor);
    }

    @Override
    public void calculateComponent() {
        super.calculateComponent();
        this.mapGraphiteConsume = new HashMap<Integer, Double>();
        for (int i = 0; i < this.x; ++i) {
            double col = 0.0;
            for (LogicCreativeComponent component : this.rodsList) {
                if (component.getX() != i) continue;
                col += component.heat * 0.83 / 160.0;
            }
            this.mapGraphiteConsume.put(i, col);
        }
    }

    @Override
    public void onTick() {
        if (this.rodsList.isEmpty()) {
            if (this.temp_heat >= 1.0) {
                this.temp_heat -= (double)rand.nextInt((int)this.temp_heat);
            }
            this.reactor.setOutput(0.0);
        } else {
            super.onTick();
            if (this.temp_heat < this.getMaxHeat() && this.getMaxHeat() != 0.0) {
                double temp = this.getMaxHeat() - this.temp_heat;
                this.temp_heat += (double)rand.nextInt(Math.max((int)temp, 1));
            }
            this.temp_heat = this.workCoolant(this.temp_heat);
            for (int i = 0; i < this.reactor.getWidth(); ++i) {
                if (this.mapGraphiteConsume.get(i) == 0.0) continue;
                double col = this.mapGraphiteConsume.get(i);
                if (this.temp_heat > this.getMaxHeat()) {
                    this.temp_heat -= (double)rand.nextInt((int)(this.temp_heat - this.getMaxHeat()));
                    if (this.temp_heat < 0.0) {
                        this.temp_heat = 0.0;
                    }
                }
                this.temp_heat -= (double)rand.nextInt((int)(10.0 * col));
                if (!(this.temp_heat < 0.0)) continue;
                this.temp_heat = 0.0;
            }
            if (this.temp_heat < 0.0) {
                this.temp_heat = 0.0;
            }
            this.reactor.setHeat(this.temp_heat);
        }
    }

    private double workCoolant(double heat) {
        for (int i = 0; i < this.coolant[this.reactor.getBlockLevel() - 1]; ++i) {
            heat = this.work(heat);
        }
        return heat;
    }

    private double work(double heat) {
        return Math.max(1.0, heat - (double)rand.nextInt(40 * this.reactor.getBlockLevel()));
    }

    public double getTemp_heat() {
        return this.temp_heat;
    }

    public void setTemp_heat(double temp_heat) {
        this.temp_heat = temp_heat;
    }
}

