/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.CreativeReactor;
import com.denfop.api.reactors.LogicCreativeComponent;
import com.denfop.api.reactors.LogicCreativeReactor;
import java.util.HashMap;
import java.util.Map;

public class LogicCreativeHeatReactor
extends LogicCreativeReactor {
    public double temp_heat = 0.0;
    int[] pump = new int[]{1, 2, 4, 8};
    int[] power_pump = new int[]{1, 2, 3, 4};
    private HashMap<Integer, Double> mapGraphiteConsume;

    public LogicCreativeHeatReactor(CreativeReactor advReactor) {
        super(advReactor);
    }

    @Override
    public void calculateComponent() {
        super.calculateComponent();
        this.mapGraphiteConsume = new HashMap();
        for (int i = 0; i < this.x; ++i) {
            double col = 0.0;
            for (LogicCreativeComponent component : this.rodsList) {
                if (component.getX() != i) continue;
                col += component.heat * 0.83 / 160.0;
            }
            if (col == 0.0) continue;
            this.mapGraphiteConsume.put(i, col);
        }
    }

    @Override
    public void onTick() {
        if (this.rodsList.isEmpty()) {
            if (this.temp_heat >= 1.0) {
                this.temp_heat -= (double)rand.nextInt((int)this.temp_heat);
            }
            this.reactor.setOutput(0.0);
        } else {
            for (Map.Entry<Integer, Double> ignored : this.mapGraphiteConsume.entrySet()) {
                this.temp_heat -= (double)rand.nextInt(100);
                if (!(this.temp_heat < 0.0)) continue;
                this.temp_heat = 0.0;
            }
            if (this.temp_heat < 0.0) {
                this.temp_heat = 0.0;
            }
            int temp = (int)((double)this.generation * 1.05);
            super.onTick();
            if (this.temp_heat < 0.0) {
                this.temp_heat = 0.0;
            }
            if (this.temp_heat >= 0.0 && this.temp_heat < this.getMaxHeat() && this.getMaxHeat() > 1.0) {
                this.temp_heat += (double)rand.nextInt((int)(this.getMaxHeat() - this.temp_heat));
            }
            for (int j = 0; j < this.pump[this.reactor.getBlockLevel() - 1]; ++j) {
                int col;
                int power = this.power_pump[this.reactor.getBlockLevel() - 1];
                if (power > (col = rand.nextInt(10))) {
                    this.temp_heat -= (double)rand.nextInt(20 * power);
                    if (this.temp_heat < 0.0) {
                        this.temp_heat = 0.0;
                    }
                } else {
                    this.temp_heat -= (double)rand.nextInt(10 * power);
                    if (this.temp_heat < 0.0) {
                        this.temp_heat = 0.0;
                    }
                }
                if (rand.nextInt(80) <= 15 * power) continue;
                this.temp_heat -= (double)rand.nextInt(power * 20);
                if (!(this.temp_heat < 0.0)) continue;
                this.temp_heat = 0.0;
            }
            this.reactor.setOutput(temp);
        }
        this.reactor.setHeat(this.temp_heat);
    }

    public double getTemp_heat() {
        return this.temp_heat;
    }

    public void setTemp_heat(double temp_heat) {
        this.temp_heat = temp_heat;
    }
}

