/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BaseFluidMachineRecipe {
    public final IInputFluid input;
    public final List<FluidStack> output_fluid;
    private final RecipeOutput output;

    public BaseFluidMachineRecipe(IInputFluid input, List<FluidStack> output) {
        this.input = input;
        this.output_fluid = output;
        this.output = null;
    }

    public BaseFluidMachineRecipe(IInputFluid input, RecipeOutput output) {
        this.input = input;
        this.output_fluid = new ArrayList<FluidStack>();
        this.output = output;
    }

    public BaseFluidMachineRecipe(IInputFluid input, RecipeOutput output, List<FluidStack> output_fluid) {
        this.input = input;
        this.output_fluid = output_fluid;
        this.output = output;
    }

    public boolean matches(List<FluidStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (!this.input.getInputs().get(i).getFluid().equals(stacks.get(i).getFluid())) continue;
            return true;
        }
        return false;
    }

    public RecipeOutput getOutput() {
        return this.output;
    }

    public List<FluidStack> getOutput_fluid() {
        return this.output_fluid;
    }

    public IInputFluid getInput() {
        return this.input;
    }

    public static BaseFluidMachineRecipe readNBT(CompoundTag tag) {
        InputFluid input = InputFluid.readNBT(tag.m_128469_("Input"));
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ListTag fluidsTag = tag.m_128437_("OutputFluids", 10);
        for (Tag fluidTag : fluidsTag) {
            if (!(fluidTag instanceof CompoundTag)) continue;
            CompoundTag fluidCompound = (CompoundTag)fluidTag;
            fluids.add(FluidStack.loadFluidStackFromNBT((CompoundTag)fluidCompound));
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListTag itemsTag = tag.m_128437_("OutputItems", 10);
        for (Tag itemTag : itemsTag) {
            if (!(itemTag instanceof CompoundTag)) continue;
            CompoundTag itemCompound = (CompoundTag)itemTag;
            items.add(ItemStack.m_41712_((CompoundTag)itemCompound));
        }
        CompoundTag metadata = tag.m_128425_("Metadata", 10) ? tag.m_128469_("Metadata") : null;
        RecipeOutput output = new RecipeOutput(metadata, items);
        return new BaseFluidMachineRecipe(input, output, fluids);
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Input", (Tag)this.input.writeNBT());
        ListTag fluidsTag = new ListTag();
        for (FluidStack fluid : this.output_fluid) {
            CompoundTag fluidTag = new CompoundTag();
            fluid.writeToNBT(fluidTag);
            fluidsTag.add((Object)fluidTag);
        }
        tag.m_128365_("OutputFluids", (Tag)fluidsTag);
        ListTag itemsTag = new ListTag();
        if (this.output != null) {
            for (ItemStack stack : this.output.items) {
                itemsTag.add((Object)stack.m_41739_(new CompoundTag()));
            }
        }
        tag.m_128365_("OutputItems", (Tag)itemsTag);
        if (this.output != null && this.output.metadata != null) {
            tag.m_128365_("Metadata", (Tag)this.output.metadata);
        }
        return tag;
    }
}

