/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.recipe.IInput;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class BaseMachineRecipe {
    public final IInput input;
    public final RecipeOutput output;

    public BaseMachineRecipe(IInput input, RecipeOutput output) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (!this.input.getInputs().get(i).matches(stacks.get(i))) continue;
            return true;
        }
        return false;
    }

    public RecipeOutput getOutput() {
        return this.output;
    }

    public static BaseMachineRecipe readNBT(CompoundTag tag) {
        Input input = Input.readNBT(tag.m_128469_("Input"));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListTag itemsTag = tag.m_128437_("Items", 10);
        for (Tag t : itemsTag) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag itemTag = (CompoundTag)t;
            items.add(ItemStack.m_41712_((CompoundTag)itemTag));
        }
        CompoundTag metadata = tag.m_128425_("Metadata", 10) ? tag.m_128469_("Metadata") : null;
        RecipeOutput output = new RecipeOutput(metadata, items);
        return new BaseMachineRecipe(input, output);
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Input", (Tag)this.input.writeNBT());
        ListTag itemsTag = new ListTag();
        if (this.output != null && this.output.items != null) {
            for (ItemStack stack : this.output.items) {
                if (stack == null) continue;
                itemsTag.add((Object)stack.m_41739_(new CompoundTag()));
            }
        }
        tag.m_128365_("Items", (Tag)itemsTag);
        if (this.output != null && this.output.metadata != null) {
            tag.m_128365_("Metadata", (Tag)this.output.metadata);
        }
        return tag;
    }
}

