/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.componets.Fluids;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidHandlerRecipe {
    private final Fluids component;
    List<FluidTank> inputTank = new ArrayList<FluidTank>();
    List<FluidTank> outputTank = new ArrayList<FluidTank>();
    private BaseFluidMachineRecipe output;
    private IBaseRecipe name;
    private List<BaseFluidMachineRecipe> list_recipe;

    public FluidHandlerRecipe(String name) {
        this.component = null;
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(name);
        this.output = null;
    }

    public FluidHandlerRecipe(String name, Fluids fluid_component) {
        this.component = fluid_component;
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(name);
        ArrayList list = new ArrayList();
        fluid_component.getAllTanks().forEach(list::add);
        for (Fluids.InternalFluidTank internalFluidTank : list) {
            if (internalFluidTank.isInput()) {
                this.inputTank.add(internalFluidTank);
                continue;
            }
            this.outputTank.add(internalFluidTank);
        }
        this.output = null;
    }

    public List<FluidTank> getInputTank() {
        return this.inputTank;
    }

    public List<FluidTank> getOutputTank() {
        return this.outputTank;
    }

    public void setTanks(List<Fluids.InternalFluidTank> fluidTanks) {
        this.inputTank.clear();
        this.outputTank.clear();
        for (Fluids.InternalFluidTank internalFluidTank : fluidTanks) {
            if (internalFluidTank.isInput()) {
                this.inputTank.add(internalFluidTank);
                continue;
            }
            this.outputTank.add(internalFluidTank);
        }
        this.output = null;
    }

    public List<Fluid> getFluids(int i) {
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        for (BaseFluidMachineRecipe machineRecipe : this.list_recipe) {
            fluids.add(machineRecipe.input.getInputs().get(i).getFluid());
        }
        return new ArrayList<Fluid>(fluids);
    }

    public List<Fluid> getOutputFluids(int i) {
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        for (BaseFluidMachineRecipe machineRecipe : this.list_recipe) {
            fluids.add(machineRecipe.output_fluid.get(i).getFluid());
        }
        return new ArrayList<Fluid>(fluids);
    }

    public List<BaseFluidMachineRecipe> getList_recipe() {
        return this.list_recipe;
    }

    public void load() {
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(this.name.getName());
        this.getOutput();
    }

    public void load(ItemStack stack) {
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(this.name.getName());
        this.getOutput(stack);
    }

    public Fluids getComponent() {
        return this.component;
    }

    public boolean canOperate() {
        for (int i = 0; i < this.name.getSize(); ++i) {
            if (this.inputTank.get(i).getFluidAmount() >= this.output.input.getInputs().get(i).getAmount()) continue;
            return false;
        }
        return true;
    }

    public boolean canOperate1(FluidTank fluidTank) {
        for (int i = 0; i < this.name.getSize(); ++i) {
            if (fluidTank.getFluidAmount() >= this.output.input.getInputs().get(i).getAmount()) continue;
            return false;
        }
        return true;
    }

    public void consume() {
        for (int i = 0; i < this.name.getSize(); ++i) {
            this.inputTank.get(i).drain(this.output.input.getInputs().get(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void consume(FluidTank fluidTank) {
        for (int i = 0; i < this.name.getSize(); ++i) {
            fluidTank.drain(this.output.input.getInputs().get(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public BaseFluidMachineRecipe output() {
        return this.output;
    }

    public IBaseRecipe getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.getOutput();
    }

    public BaseFluidMachineRecipe getOutput(FluidTank tank) {
        if (this.output != null) {
            return this.output;
        }
        this.output = null;
        if (tank == null) {
            return this.output;
        }
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        if (tank.getFluidAmount() == 0) {
            return this.output;
        }
        fluidStackList.add(tank.getFluid());
        this.output = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
        return this.output;
    }

    public BaseFluidMachineRecipe getOutput() {
        if (this.output != null) {
            return this.output;
        }
        if (this.inputTank.isEmpty()) {
            return null;
        }
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                return null;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
        return this.output;
    }

    public void setOutput(BaseFluidMachineRecipe baseFluidMachineRecipe) {
        this.output = baseFluidMachineRecipe;
    }

    public BaseFluidMachineRecipe getOutput(ItemStack stack) {
        if (this.output != null) {
            return this.output;
        }
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                return null;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, stack);
        return this.output;
    }

    public void checkOutput(FluidTank tank) {
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        if (tank.getFluidAmount() == 0) {
            if (this.output != null) {
                this.output = null;
            }
            return;
        }
        fluidStackList.add(tank.getFluid());
        this.output = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
    }

    public void checkOutput() {
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                if (this.output != null) {
                    this.output = null;
                }
                return;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
    }

    public boolean canFillFluid() {
        if (this.output != null) {
            for (int i = 0; i < this.outputTank.size(); ++i) {
                FluidTank fluidTank = this.outputTank.get(i);
                FluidStack fluid = this.output.output_fluid.get(i);
                if (!fluidTank.getFluid().isEmpty() && !fluid.isFluidEqual(fluidTank.getFluid())) {
                    return false;
                }
                if (fluidTank.getFluidAmount() + fluid.getAmount() <= fluidTank.getCapacity()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canFillFluid1() {
        if (this.output != null) {
            for (FluidTank fluidTank : this.outputTank) {
                FluidStack fluid = this.output.output_fluid.get(0);
                if (fluidTank.getFluidAmount() + fluid.getAmount() >= fluidTank.getCapacity() || !fluidTank.getFluid().isEmpty() && fluidTank.getFluid().getFluid() != fluid.getFluid()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean canFillFluid(FluidStack fluidStack) {
        for (FluidTank fluidTank : this.outputTank) {
            if (fluidTank.getFluidAmount() + fluidStack.getAmount() > fluidTank.getCapacity() && (fluidTank.getFluid().isEmpty() || fluidTank.getFluid().getFluid() == fluidStack.getFluid())) continue;
            return true;
        }
        return false;
    }

    public boolean hasFluid(FluidStack fluidStack, FluidTank fluidTank) {
        if (fluidStack == null) {
            return false;
        }
        return fluidTank.getFluidAmount() >= fluidStack.getAmount() && !fluidTank.getFluid().isEmpty() && fluidTank.getFluid().getFluid() == fluidStack.getFluid();
    }

    public void drainFluid(FluidStack fluidStack, FluidTank fluidTank) {
        if (fluidStack == null) {
            return;
        }
        fluidTank.drain(fluidStack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
    }

    public void fillFluid() {
        if (this.output != null) {
            for (int i = 0; i < this.outputTank.size(); ++i) {
                this.outputTank.get(i).fill(this.output.output_fluid.get(i), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public void fillFluid(FluidStack fluidStack) {
        for (FluidTank tank : this.outputTank) {
            if (!tank.getFluid().isEmpty() && (!tank.getFluid().isFluidEqual(fluidStack) || tank.getFluid().getAmount() + fluidStack.getAmount() > tank.getCapacity())) continue;
            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
    }

    public void fillFluid1() {
        if (this.output != null) {
            for (FluidTank tank : this.outputTank) {
                if (!tank.getFluid().isEmpty() && (!tank.getFluid().isFluidEqual(this.output.output_fluid.get(0)) || tank.getFluid().getAmount() + this.output.output_fluid.get(0).getAmount() > tank.getCapacity())) continue;
                tank.fill(this.output.output_fluid.get(0), IFluidHandler.FluidAction.EXECUTE);
                break;
            }
        }
    }

    public boolean checkFluids() {
        if (this.output != null) {
            for (FluidTank fluidTank : this.inputTank) {
                if (fluidTank.getFluidAmount() != 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

