/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.tesseract;

import com.denfop.api.tesseract.ITesseract;
import com.denfop.api.tesseract.TypeChannel;
import com.denfop.api.tesseract.TypeMode;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class Channel {
    private final int channel;
    private TypeMode mode;
    private TypeChannel typeChannel;
    private ITesseract tesseract;
    private boolean isPrivate;
    private boolean active;
    private BlockPos pos;

    public Channel(int channel, ITesseract tesseract, TypeMode mode, TypeChannel typeChannel, boolean isPrivate) {
        this.channel = channel;
        this.mode = mode;
        this.typeChannel = typeChannel;
        this.active = false;
        this.isPrivate = isPrivate;
        this.tesseract = tesseract;
        this.pos = tesseract.getPos();
    }

    public Channel(int channel, TypeMode mode, TypeChannel typeChannel, boolean isPrivate) {
        this.channel = channel;
        this.mode = mode;
        this.typeChannel = typeChannel;
        this.active = false;
        this.isPrivate = isPrivate;
        this.tesseract = null;
        this.pos = BlockPos.f_121853_;
    }

    public Channel(CustomPacketBuffer customPacketBuffer) {
        this.channel = customPacketBuffer.readInt();
        this.mode = TypeMode.values()[customPacketBuffer.readInt()];
        this.typeChannel = TypeChannel.values()[customPacketBuffer.readInt()];
        this.active = customPacketBuffer.readBoolean();
        this.isPrivate = customPacketBuffer.readBoolean();
    }

    public Channel(CompoundTag nbtTagCompound) {
        this.channel = nbtTagCompound.m_128451_("channel");
        this.mode = TypeMode.values()[nbtTagCompound.m_128451_("mode")];
        this.typeChannel = TypeChannel.values()[nbtTagCompound.m_128451_("typeChannel")];
        this.active = nbtTagCompound.m_128471_("active");
        this.isPrivate = nbtTagCompound.m_128471_("isPrivate");
    }

    public ITesseract getTesseract() {
        return this.tesseract;
    }

    public void setTesseract(ITesseract tesseract) {
        this.tesseract = tesseract;
        this.pos = tesseract.getPos();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel1 = (Channel)o;
        return this.channel == channel1.channel && Objects.equals(this.tesseract, channel1.tesseract);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.tesseract);
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeInt(this.channel);
        packetBuffer.writeInt(this.mode.ordinal());
        packetBuffer.writeInt(this.typeChannel.ordinal());
        packetBuffer.writeBoolean(this.active);
        packetBuffer.writeBoolean(this.isPrivate);
        return packetBuffer;
    }

    public CompoundTag writeNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128405_("channel", this.channel);
        tagCompound.m_128405_("mode", this.mode.ordinal());
        tagCompound.m_128405_("typeChannel", this.typeChannel.ordinal());
        tagCompound.m_128379_("active", this.active);
        tagCompound.m_128379_("isPrivate", this.isPrivate);
        return tagCompound;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean aPrivate) {
        this.isPrivate = aPrivate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public TypeChannel getTypeChannel() {
        return this.typeChannel;
    }

    public void setTypeChannel(TypeChannel typeChannel) {
        this.typeChannel = typeChannel;
    }

    public int getChannel() {
        return this.channel;
    }

    public TypeMode getMode() {
        return this.mode;
    }

    public void setMode(TypeMode mode) {
        this.mode = mode;
    }
}

