/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein.common;

import com.denfop.api.vein.common.Type;
import com.denfop.api.vein.common.Vein;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;

public class VeinBase
implements Vein {
    private final ChunkPos chunk;
    boolean find;
    private boolean oldMineral;
    private Type type;
    private int meta;
    private int col;
    private int maxcol;

    public VeinBase(Type type, int meta, ChunkPos chunk) {
        this.type = type;
        this.meta = meta;
        this.chunk = chunk;
        this.col = 0;
        this.maxcol = 0;
        this.oldMineral = false;
    }

    public VeinBase(CompoundTag tagCompound) {
        int data1;
        int sign1;
        int data = tagCompound.m_128451_("data");
        int z = data & 0x7FF;
        int x = (data >>= 11) & 0x7FF;
        int sign = (data >>= 11) & 1;
        if (sign == 0) {
            z *= -1;
        }
        if ((sign1 = (data >>= 1) & 1) == 0) {
            x *= -1;
        }
        int find = (data >>= 1) & 1;
        int type = (data >>= 1) & 3;
        this.meta = (data >>= 2) & 0xF;
        this.type = Type.getID(type);
        this.chunk = new ChunkPos(x, z);
        this.col = tagCompound.m_128451_("col");
        this.maxcol = tagCompound.m_128451_("maxcol");
        boolean bl = this.find = find == 1;
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
        this.oldMineral = (data1 = tagCompound.m_128451_("data1")) == 0;
    }

    public VeinBase(CustomPacketBuffer is) {
        int data2;
        int sign1;
        int data = is.readInt();
        int z = data & 0x7FF;
        int x = (data >>= 11) & 0x7FF;
        int sign = (data >>= 11) & 1;
        if (sign == 0) {
            z *= -1;
        }
        if ((sign1 = (data >>= 1) & 1) == 0) {
            x *= -1;
        }
        int find = (data >>= 1) & 1;
        int type = (data >>= 1) & 3;
        this.meta = (data >>= 2) & 0xF;
        this.type = Type.getID(type);
        this.chunk = new ChunkPos(x, z);
        this.col = is.readInt();
        this.maxcol = is.readInt();
        boolean bl = this.find = find == 1;
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
        this.oldMineral = (data2 = is.readInt()) == 0;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(32);
        int m = 0;
        m += this.meta;
        m = (m << 2) + this.type.ordinal();
        m = (m << 1) + (this.find ? 1 : 0);
        boolean k = this.chunk.f_45578_ >= 0;
        boolean k1 = this.chunk.f_45579_ >= 0;
        m = (m << 1) + (k ? 1 : 0);
        m = (m << 1) + (k1 ? 1 : 0);
        int x = Math.min(Math.abs(this.chunk.f_45578_), 2047);
        int z = Math.min(Math.abs(this.chunk.f_45579_), 2047);
        m = (m << 11) + x;
        m = (m << 11) + z;
        customPacketBuffer.writeInt(m);
        customPacketBuffer.writeInt(this.col);
        customPacketBuffer.writeInt(this.maxcol);
        customPacketBuffer.writeInt(this.oldMineral ? 0 : 1);
        return customPacketBuffer;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(int meta) {
        this.meta = this.oldMineral ? meta : meta - 16;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public ChunkPos getChunk() {
        return this.chunk;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public void setCol(int col) {
        this.col = col;
    }

    @Override
    public int getMaxCol() {
        return this.maxcol;
    }

    @Override
    public void setMaxCol(int maxcol) {
        this.maxcol = maxcol;
    }

    @Override
    public void removeCol(int col) {
        assert (this.col - col >= 0);
        this.col -= col;
    }

    public boolean isFind() {
        return this.find;
    }

    @Override
    public void setFind(boolean find) {
        this.find = find;
    }

    @Override
    public boolean isOldMineral() {
        return this.oldMineral;
    }

    public void setOldMineral(boolean oldMineral) {
        this.oldMineral = oldMineral;
    }

    @Override
    public boolean canMining() {
        return this.type == Type.EMPTY || this.col == 0 && this.maxcol != 0;
    }

    @Override
    public CompoundTag writeTag() {
        CompoundTag tagCompound = new CompoundTag();
        int m = 0;
        m += this.meta;
        m = (m << 2) + this.type.ordinal();
        m = (m << 1) + (this.find ? 1 : 0);
        boolean k = this.chunk.f_45578_ >= 0;
        boolean k1 = this.chunk.f_45579_ >= 0;
        m = (m << 1) + (k ? 1 : 0);
        m = (m << 1) + (k1 ? 1 : 0);
        int x = Math.min(Math.abs(this.chunk.f_45578_), 2047);
        int z = Math.min(Math.abs(this.chunk.f_45579_), 2047);
        m = (m << 11) + x;
        m = (m << 11) + z;
        tagCompound.m_128405_("data", m);
        tagCompound.m_128405_("col", this.col);
        tagCompound.m_128405_("maxcol", this.maxcol);
        tagCompound.m_128405_("data1", this.oldMineral ? 0 : 1);
        return tagCompound;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VeinBase vein = (VeinBase)o;
        return vein.chunk.equals((Object)this.chunk);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chunk, this.find, this.type, this.meta, this.col, this.maxcol});
    }

    @Override
    public boolean get() {
        return this.find;
    }
}

