/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein.gas;

import com.denfop.api.vein.gas.GasBaseVein;
import com.denfop.api.vein.gas.GasVeinBaseSystem;
import com.denfop.api.vein.gas.TypeGas;
import com.denfop.config.ModConfig;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;

public class GasVeinSystem
implements GasVeinBaseSystem {
    public static GasVeinBaseSystem system;
    public static GasBaseVein EMPTY;
    private final Random rand;
    List<GasBaseVein> list;
    List<ChunkPos> chunkPos;
    Map<ChunkPos, GasBaseVein> chunkPosVeinMap;

    public GasVeinSystem() {
        system = this;
        this.list = new LinkedList<GasBaseVein>();
        this.chunkPos = new LinkedList<ChunkPos>();
        this.chunkPosVeinMap = new HashMap<ChunkPos, GasBaseVein>();
        this.rand = new Random();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public GasBaseVein getEMPTY() {
        return EMPTY;
    }

    @Override
    public List<ChunkPos> getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public List<GasBaseVein> getVeinsList() {
        return this.list;
    }

    @Override
    public void addVein(ChunkAccess chunk) {
        int chance = this.rand.nextInt(100);
        GasBaseVein vein = new GasBaseVein(TypeGas.NONE, chunk.m_7697_());
        if (chance < (Integer)ModConfig.COMMON.gasChance.get()) {
            vein.setType(TypeGas.values()[this.rand.nextInt(4) + 1]);
            vein.setMaxCol((Integer)ModConfig.COMMON.gasMaxVein.get());
            vein.setCol((Integer)ModConfig.COMMON.gasMaxVein.get());
        }
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public void addVein(CompoundTag tag) {
        GasBaseVein vein = new GasBaseVein(tag);
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public GasBaseVein getVein(ChunkPos pos) {
        return this.chunkPosVeinMap.getOrDefault(pos, EMPTY);
    }

    @Override
    public void unload() {
        this.list.clear();
        this.chunkPos.clear();
        this.chunkPosVeinMap.clear();
    }

    static {
        EMPTY = new GasBaseVein(TypeGas.NONE, new ChunkPos(999999999, 999999999));
    }
}

