/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.ScreenWidget;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidDefaultWidget
extends ScreenWidget {
    private final FluidStack fluid;

    public FluidDefaultWidget(ScreenIndustrialUpgrade<?> gui, int x, int y, FluidStack fluid) {
        super(gui, x, y, 18, 18);
        this.fluid = fluid;
    }

    @Override
    public void drawForeground(PoseStack poseStack, int mouseX, int mouseY) {
        if (mouseX >= this.f_93620_ && mouseX < this.f_93620_ + 18 && mouseY >= this.f_93621_ && mouseY < this.f_93621_ + 18) {
            String tooltip;
            List<String> lines = this.getToolTip();
            if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                FluidDefaultWidget.addLines(lines, tooltip);
            }
            if (!lines.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, lines);
            }
        }
    }

    @Override
    public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
        FluidDefaultWidget.bindCommonTexture();
        FluidStack fs = this.fluid;
        if (!fs.isEmpty() && fs.getAmount() > 0) {
            int fluidX = this.f_93620_ + 1;
            int fluidY = this.f_93621_ + 1;
            int fluidWidth = 16;
            int fluidHeight = 16;
            Fluid fluid = fs.getFluid();
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = FluidDefaultWidget.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
            int color = extensions.getTintColor();
            FluidDefaultWidget.bindBlockTexture();
            this.gui.drawSprite(poseStack, mouseX + fluidX, mouseY + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
        }
        ScreenIndustrialUpgrade.bindTexture(commonTexture1);
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.fluid;
        if (fs != null && fs.getAmount() > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(Localization.translate(fs.getTranslationKey()));
                ret.add("Amount: " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                ret.add("Type: Liquid");
            } else {
                ret.add("Invalid FluidStack instance.");
            }
        } else {
            ret.add("No Fluid");
            ret.add("Amount: 0 " + Localization.translate("iu.generic.text.mb"));
            ret.add("Type: Not Available");
        }
        return ret;
    }
}

