/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.ButtonListSliderWidget;
import com.denfop.api.widget.ScrollDirection;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VerticalSliderListWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURES = new ResourceLocation("industrialupgrade", "textures/gui/slider.png");
    private final String name;
    private final int def;
    private final FormatHelper formatHelper;
    private final ButtonListSliderWidget.WidgetResponder responder;
    private final int id;
    private String displayString1;
    private int min;
    private int max;
    private int sizeRender;
    private float sliderPosition = 1.0f;
    private boolean isMouseDown;

    public VerticalSliderListWidget(ButtonListSliderWidget.WidgetResponder p_i45541_1_, int p_i45541_2_, int x, int y, String name, int min, int max, int def, FormatHelper p_i45541_9_, int height) {
        super(x, y, 1, height, (Component)Component.m_237113_((String)name));
        this.name = name;
        this.min = min;
        this.id = p_i45541_2_;
        this.max = max;
        this.def = def;
        this.sliderPosition = (float)(def - min) / (float)(max - min);
        this.updateRenderSize();
        this.formatHelper = p_i45541_9_;
        this.responder = p_i45541_1_;
        this.displayString1 = this.getDisplayString();
    }

    private String getDisplayString() {
        return this.formatHelper == null ? I18n.m_118938_((String)this.name, (Object[])new Object[0]) + ": " + this.getSliderValue() : this.formatHelper.getText(this.id, I18n.m_118938_((String)this.name, (Object[])new Object[0]), this.getSliderValue());
    }

    private void updateRenderSize() {
        this.sizeRender = Math.max(1, (int)Math.floor((double)this.f_93619_ * ((double)(this.max - this.min) / ((double)this.max + 1.0))));
    }

    public float getSliderValue() {
        return (float)this.min + (float)(this.max - this.min) * this.sliderPosition;
    }

    public void setSliderValue(float value) {
        this.sliderPosition = (value - (float)this.min) / (float)(this.max - this.min);
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        this.m_93228_(stack, this.f_93620_, this.f_93621_ - 1, 255, 0, 4, this.f_93619_ - 2);
        int sliderY = (int)((float)this.f_93621_ + (float)(this.f_93619_ - this.sizeRender) * this.sliderPosition);
        this.m_93228_(stack, this.f_93620_ - 1, sliderY, 12, 13, 4, this.sizeRender);
        VerticalSliderListWidget.m_93208_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (String)this.getDisplayString(), (int)(this.f_93620_ + 4), (int)(this.f_93621_ + this.f_93619_ / 2 - 4), (int)0xFFFFFF);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.isMouseDown = true;
            this.updateSliderPosition(mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isMouseDown = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isMouseDown) {
            this.updateSliderPosition(mouseY);
            return true;
        }
        return false;
    }

    private void updateSliderPosition(double mouseY) {
        this.sliderPosition = (float)((mouseY - (double)this.f_93621_) / (double)(this.f_93619_ - this.sizeRender));
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
        this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
    }

    public void m_142291_(NarrationElementOutput output) {
        output.m_169143_(NarratedElementType.TITLE, this.getDisplayString());
    }

    public void setMin(int min) {
        this.min = min;
        this.setMax(this.max);
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.f_93620_ - 4 && mouseX < this.f_93620_ + 4 && mouseY >= this.f_93621_ && mouseY < this.f_93621_ + this.f_93619_;
    }

    public boolean handleMouseWheel(ScrollDirection direction, int mouseX, int mouseY) {
        if (this.f_93624_ && this.isMouseOver(mouseX, mouseY)) {
            float step = 1.0f / (float)(this.max - this.min);
            this.sliderPosition += direction == ScrollDirection.down ? step : -step;
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.displayString1 = this.getDisplayString();
            this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
            return true;
        }
        return false;
    }

    public void setMax(int p_i45541_7_) {
        if (this.max != p_i45541_7_) {
            this.max = p_i45541_7_;
            this.sizeRender = this.max == 0 ? this.f_93619_ : (int)((double)(this.f_93619_ - 8) / ((double)(this.max - this.min) * 1.0));
            if (this.sizeRender < 1) {
                this.sizeRender = 1;
            }
            this.sliderPosition = (float)((double)this.def * ((double)(this.f_93619_ - 8) / ((double)(this.max - this.min) * 1.0)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface FormatHelper {
        public String getText(int var1, String var2, float var3);
    }
}

