/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.otherenergies.cool.ICoolSink;
import com.denfop.api.otherenergies.heat.IHeatSink;
import com.denfop.api.widget.EnumTypeRender;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentBioFuelEnergy;
import com.denfop.componets.ComponentBioProcessRender;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentProcessRender;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.ComponentSteamProcessRender;
import com.denfop.componets.ComponentTimer;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.PressureComponent;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WidgetDefault<T> {
    private final T component;

    public WidgetDefault(T component) {
        this.component = component;
    }

    public T getComponent() {
        return this.component;
    }

    public boolean visible() {
        return true;
    }

    public void drawBackground(PoseStack poseStack, int mouseX, int mouseY, ScreenWidget screenWidget) {
        if (this.visible()) {
            if (this.component instanceof Energy) {
                Energy component = (Energy)this.component;
                double fillratio = component.getFillRatio();
                fillratio = Math.min(1.0, fillratio);
                if (screenWidget.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getHeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getX1(), screenWidget.getType().getY1() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getWeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY(), screenWidget.getType().getX1(), screenWidget.getType().getY1(), chargeLevel, screenWidget.getType().getHeight());
                }
            } else if (this.component instanceof ComponentSteamEnergy) {
                ComponentSteamEnergy component = (ComponentSteamEnergy)this.component;
                if (component != null && component.buffer.storage >= 1.0) {
                    FluidStack fs = new FluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), 1);
                    int fluidX = screenWidget.f_93620_ + 1;
                    int fluidY = screenWidget.f_93621_ + 1;
                    int fluidWidth = 16;
                    int fluidHeight = 16;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = ScreenWidget.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    ScreenWidget.bindBlockTexture();
                    screenWidget.getGui().drawSprite(poseStack, mouseX + fluidX, mouseY + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
                }
            } else if (this.component instanceof ComponentBioFuelEnergy) {
                ComponentBioFuelEnergy component = (ComponentBioFuelEnergy)this.component;
                if (component != null && component.buffer.storage >= 1.0) {
                    FluidStack fs = new FluidStack((Fluid)FluidName.fluidbiomass.getInstance().get(), 1);
                    int fluidX = screenWidget.f_93620_ + 1;
                    int fluidY = screenWidget.f_93621_ + 1;
                    int fluidWidth = 16;
                    int fluidHeight = 16;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = ScreenWidget.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    ScreenWidget.bindBlockTexture();
                    screenWidget.getGui().drawSprite(poseStack, mouseX + fluidX, mouseY + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
                }
            } else if (this.component instanceof ComponentBaseEnergy) {
                ComponentBaseEnergy component = (ComponentBaseEnergy)this.component;
                double fillratio = component.buffer.storage / component.buffer.capacity;
                if (screenWidget.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getHeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getX1(), screenWidget.getType().getY1() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getWeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY(), screenWidget.getType().getX1(), screenWidget.getType().getY1(), chargeLevel, screenWidget.getType().getHeight());
                }
            } else if (this.component instanceof CoolComponent) {
                CoolComponent component = (CoolComponent)this.component;
                double fillratio = component.buffer.storage / component.buffer.capacity;
                if (screenWidget.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getHeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getX1(), screenWidget.getType().getY1() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getWeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY(), screenWidget.getType().getX1(), screenWidget.getType().getY1(), chargeLevel, screenWidget.getType().getHeight());
                }
            } else if (this.component instanceof HeatComponent) {
                HeatComponent component = (HeatComponent)this.component;
                double fillratio = component.buffer.storage / component.buffer.capacity;
                if (screenWidget.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getHeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getX1(), screenWidget.getType().getY1() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getWeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY(), screenWidget.getType().getX1(), screenWidget.getType().getY1(), chargeLevel, screenWidget.getType().getHeight());
                }
            } else if (this.component instanceof FluidTank) {
                FluidTank component = (FluidTank)this.component;
                double fillratio = (double)component.getFluidAmount() * 1.0 / (double)component.getCapacity();
                if (screenWidget.getType().getRender() == EnumTypeRender.HEIGHT) {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getHeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getX1(), screenWidget.getType().getY1() + screenWidget.getType().getHeight() - chargeLevel, screenWidget.getType().getWeight(), chargeLevel);
                } else {
                    int chargeLevel = (int)(fillratio *= (double)screenWidget.getType().getWeight());
                    screenWidget.getGui().drawTexturedModalRect(poseStack, mouseX + screenWidget.getX() + screenWidget.getType().getEndX(), mouseY + screenWidget.getType().getEndY() + screenWidget.getY(), screenWidget.getType().getX1(), screenWidget.getType().getY1(), chargeLevel + 1, screenWidget.getType().getHeight());
                }
            }
        }
    }

    public String getText(ScreenWidget screenWidget) {
        Object text = "";
        if (this.component instanceof ComponentButton) {
            ComponentButton component = (ComponentButton)this.component;
            text = component.getText();
        } else if (this.component instanceof Energy) {
            Energy component = (Energy)this.component;
            text = ModUtils.getString(Math.min(component.getEnergy(), component.getCapacity())) + "/" + ModUtils.getString(component.getCapacity()) + " EF";
        } else if (this.component instanceof PressureComponent) {
            PressureComponent component = (PressureComponent)this.component;
            text = "Pressure: " + ModUtils.getString(Math.min(component.getEnergy(), component.getCapacity())) + "/" + ModUtils.getString(component.getCapacity());
        } else if (this.component instanceof ComponentTimer) {
            text = ((ComponentTimer)this.component).getTime();
        } else if (this.component instanceof ComponentProgress) {
            text = ModUtils.getString(Math.min(100.0, ((ComponentProgress)this.component).getBar() * 100.0)) + "%";
        } else if (this.component instanceof ComponentBaseEnergy) {
            ComponentBaseEnergy component = (ComponentBaseEnergy)this.component;
            text = ModUtils.getString(Math.min(component.getEnergy(), component.getCapacity())) + "/" + ModUtils.getString(component.getCapacity()) + component.getType().getPrefix();
        } else if (this.component instanceof ComponentProcessRender) {
            ComponentProcessRender component = (ComponentProcessRender)this.component;
            text = ModUtils.getString(component.getProcess().getProgress(screenWidget.getIndex()) * 100.0) + "%";
        } else if (this.component instanceof ComponentSteamProcessRender) {
            ComponentSteamProcessRender component = (ComponentSteamProcessRender)this.component;
            text = ModUtils.getString(component.getProcess().getProgress(screenWidget.getIndex()) * 100.0) + "%";
        } else if (this.component instanceof ComponentBioProcessRender) {
            ComponentBioProcessRender component = (ComponentBioProcessRender)this.component;
            text = ModUtils.getString(component.getProcess().getProgress(screenWidget.getIndex()) * 100.0) + "%";
        } else if (this.component instanceof CoolComponent) {
            CoolComponent component = (CoolComponent)this.component;
            if (component.delegate == null) {
                component.createDelegate();
            }
            if (component.delegate instanceof ICoolSink) {
                text = ModUtils.getString(component.getEnergy()) + "\u00b0C/" + ModUtils.getString(component.getCapacity()) + "\u00b0C";
                if (component.getEnergy() == 100.0) {
                    text = (String)text + "\n" + Localization.translate("iu.need_colling2");
                } else if (component.getEnergy() >= 50.0 && component.getEnergy() < 100.0) {
                    text = (String)text + "\n" + Localization.translate("iu.need_colling1");
                } else if (component.getEnergy() < 50.0 && component.getEnergy() > 10.0) {
                    text = (String)text + "\n" + Localization.translate("iu.need_colling");
                }
            } else {
                text = "-" + component.getEnergy() + "\u00b0C/-" + component.getCapacity();
            }
        } else if (this.component instanceof HeatComponent) {
            HeatComponent component = (HeatComponent)this.component;
            if (component.delegate == null) {
                component.createDelegate();
            }
            text = ModUtils.getString(component.getEnergy()) + "\u00b0C/" + ModUtils.getString(component.getCapacity()) + "\u00b0C";
            if (component.delegate instanceof IHeatSink && component.buffer.need) {
                text = (String)text + "\n" + Localization.translate("iu.need_heat");
            }
        } else if (this.component instanceof FluidTank) {
            FluidTank component = (FluidTank)this.component;
            String text1 = component.getFluid().getDisplayName().getString();
            if (component.getFluid().getFluid() == Fluids.f_76191_) {
                text1 = "";
            }
            text = "Fluid " + text1 + ": " + ModUtils.getString(component.getFluidAmount()) + "/" + ModUtils.getString(component.getCapacity());
        }
        return text;
    }
}

