/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.windsystem;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.api.windsystem.WindRotor;
import com.denfop.blockentity.windturbine.BlockEntityWindTurbineController;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemWindRotor;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.ModUtils;
import net.minecraft.world.item.ItemStack;

public class InventoryWindTurbineRotor
extends Inventory
implements ITypeSlot {
    private final BlockEntityWindTurbineController windGenerator;

    public InventoryWindTurbineRotor(BlockEntityWindTurbineController windGenerator) {
        super(windGenerator, Inventory.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(1);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.ROTOR;
    }

    public int damage(int amount, double chance) {
        int damageApplied = 0;
        if (chance > 0.0 && this.windGenerator.getWorld().f_46441_.m_188503_(101) > (int)(chance * 100.0)) {
            return 0;
        }
        ItemStack stack = this.get(0);
        ItemWindRotor rotor = (ItemWindRotor)stack.m_41720_();
        if (!ModUtils.isEmpty(stack)) {
            DamageHandler.damage(stack, amount, null);
            if ((double)DamageHandler.getDamage(stack) >= (double)DamageHandler.getMaxDamage(stack) * 0.25) {
                this.windGenerator.need_repair = true;
            }
        }
        return damageApplied;
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_41720_() instanceof ItemWindRotor && ((WindRotor)stack.m_41720_()).getLevel() >= 1 && ((WindRotor)stack.m_41720_()).getLevel() <= 14;
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.windGenerator.change();
        if (!content.m_41619_()) {
            this.windGenerator.energy.getEnergy().setSourceTier(this.windGenerator.getRotor().getSourceTier());
        } else {
            this.windGenerator.energy.getEnergy().setSourceTier(1);
        }
        return content;
    }
}

