/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.containermenu.ContainerMenuAntiUpgrade;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.InventoryAntiUpgradeBlock;
import com.denfop.items.modules.ItemUpgradeModule;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenAntiUpgradeBlock;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityAntiUpgradeBlock
extends BlockEntityElectricMachine
implements IUpdatableTileEvent {
    public final InventoryAntiUpgradeBlock input = new InventoryAntiUpgradeBlock(this);
    public int index = 0;
    public int progress = 0;
    public boolean need = false;

    public BlockEntityAntiUpgradeBlock(BlockPos pos, BlockState state) {
        super(1000.0, 14, 4, BlockBaseMachine3Entity.antiupgradeblock, pos, state);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.antiupgradeblock;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "5" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.index = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.index);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.need && !this.input.m_7983_() && this.energy.canUseEnergy(5.0)) {
            ++this.progress;
            this.energy.useEnergy(5.0);
            if (this.progress >= 100) {
                List<ItemStack> list = UpgradeSystem.system.getListStack(this.input.get(0));
                if (this.outputSlot.canAdd(list.get(this.index))) {
                    this.outputSlot.add(list.get(this.index));
                }
                UpgradeSystem.system.removeUpdate(this.input.get(0), this.getWorld(), ((ISubEnum)((ItemUpgradeModule)list.get(this.index).m_41720_()).getElement()).getId());
                this.need = false;
                this.progress = 0;
            }
        }
    }

    public ContainerMenuAntiUpgrade getGuiContainer(Player entityPlayer) {
        return new ContainerMenuAntiUpgrade(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAntiUpgradeBlock((ContainerMenuAntiUpgrade)menu);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128451_("progress");
        this.need = nbttagcompound.m_128471_("need");
        this.index = nbttagcompound.m_128451_("index");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("progress", this.progress);
        nbttagcompound.m_128405_("index", this.index);
        nbttagcompound.m_128379_("need", this.need);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        List<ItemStack> list;
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
            return;
        }
        if (this.input.m_7983_()) {
            return;
        }
        if (this.need && i == 0.0) {
            return;
        }
        if (i >= 1.0 && (list = UpgradeSystem.system.getListStack(this.input.get(0))) != null && (double)list.size() > i - 1.0 && !list.get((int)(i - 1.0)).m_41619_()) {
            this.index = (int)(i - 1.0);
            return;
        }
        if (i == 0.0) {
            list = UpgradeSystem.system.getListStack(this.input.get(0));
            boolean need = false;
            if (list.size() <= this.index) {
                return;
            }
            ItemStack stack = list.get(this.index);
            if (!stack.m_41619_() && this.outputSlot.canAdd(stack)) {
                need = true;
            }
            this.need = need;
        }
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

