/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.sound.EnumTypeAudio;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.EnumMultiMachine;
import com.denfop.blockentity.base.ISteamMechanism;
import com.denfop.blockentity.mechanism.EnumTypeMachines;
import com.denfop.blocks.BlockResource;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.componets.SteamProcessMultiComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamMultiMachine;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamMultiMachine;
import com.denfop.sound.EnumSound;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class BlockEntitySteamMultiMachine
extends BlockEntityInventory
implements AudioFixer,
IUpdatableTileEvent,
IHasRecipe,
ISteamMechanism {
    public final int f_58855_;
    public final SteamProcessMultiComponent multi_process;
    public final int sizeWorkingSlot;
    public final ComponentSteamEnergy steam;
    public final Fluids.InternalFluidTank fluidTank;
    public final PressureComponent pressure;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound;
    private Fluids fluid = null;

    public BlockEntitySteamMultiMachine(int energyconsume, int OperationsPerTick, int type, MultiBlockEntity block, BlockPos pos, BlockState state) {
        this(1, energyconsume, OperationsPerTick, type, block, pos, state);
    }

    public BlockEntitySteamMultiMachine(int aDefaultTier, int energyconsume, int OperationsPerTick, int type, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.sizeWorkingSlot = this.getMachine().sizeWorkingSlot;
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 1000.0));
        this.pressure = this.addComponent(PressureComponent.asBasicSink(this, 1.0));
        this.fluid = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluid.addTank("tank", OperationsPerTick * energyconsume, Inventory.TypeItemSlot.NONE);
        this.steam.setFluidTank(this.fluidTank);
        this.f_58855_ = type;
        this.sound = true;
        this.multi_process = this.addComponent(new SteamProcessMultiComponent(this, this.getMachine()));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void init() {
    }

    @Override
    public SoundEvent getSound() {
        return this.getMachine().type.getSound();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_length") + this.multi_process.operationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.getSound() == null) {
            return;
        }
        if (this.getEnable()) {
            if (soundEvent == 0) {
                this.getWorld().m_5594_(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (soundEvent == 1) {
                new PacketStopSound(this.getWorld(), this.pos);
                this.getWorld().m_5594_(null, this.pos, EnumSound.interruptone_steam.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                new PacketStopSound(this.getWorld(), this.pos);
            }
        }
    }

    public void onUpdate() {
    }

    public List<ItemStack> getDrop() {
        return this.getAuxDrops(0);
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack(IUItem.basemachine2.getItem(78), 1);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        return drop;
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        return super.getWrenchDrops(player, fortune);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand)) && this.fluid != null) {
            for (AbstractComponent component : this.componentList) {
                if (!component.onBlockActivated(player, hand)) continue;
                return true;
            }
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluid.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    public abstract EnumMultiMachine getMachine();

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.m_128471_("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128379_("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (event != 0.0) {
            this.sound = !this.sound;
            new PacketUpdateFieldTile(this, "sound", this.sound);
            if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
                this.setType(EnumTypeAudio.OFF);
                new PacketStopSound(this.getWorld(), this.pos);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "sound", this.sound);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public EnumTypeMachines getTypeMachine() {
        return this.getMachine().type;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    public ContainerMenuSteamMultiMachine getGuiContainer(Player player) {
        return new ContainerMenuSteamMultiMachine(player, this, this.sizeWorkingSlot);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamMultiMachine((ContainerMenuSteamMultiMachine)menu);
    }

    public int getMode() {
        return 0;
    }
}

