/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.tesseract.Channel;
import com.denfop.api.tesseract.ITesseract;
import com.denfop.api.tesseract.TesseractSystem;
import com.denfop.api.tesseract.TypeChannel;
import com.denfop.api.tesseract.TypeMode;
import com.denfop.api.tesseract.event.EventAdderChannel;
import com.denfop.api.tesseract.event.EventLoadTesseract;
import com.denfop.api.tesseract.event.EventRemoverChannel;
import com.denfop.api.tesseract.event.EventUnLoadTesseract;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuTesseract;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenTesseract;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockEntityTesseract
extends BlockEntityInventory
implements IUpdatableTileEvent,
ITesseract {
    private final Energy energy;
    private final Fluids fluids;
    private final Fluids.InternalFluidTank tank;
    private final Inventory slot;
    public Channel channel;
    List<Channel> channelList = new ArrayList<Channel>();
    List<Channel> publicChannel = new ArrayList<Channel>();

    public BlockEntityTesseract(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.tesseract, pos, state);
        this.energy = this.addComponent(new Energy(this, 2.147483647E9, ModUtils.allFacings, ModUtils.allFacings, 14));
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTank("tank", 64000);
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT_OUTPUT, 18);
        this.getComponentPrivate().setActivate(true);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.tesseract.info"));
    }

    @Override
    public Level getWorld() {
        return this.f_58857_;
    }

    public ContainerMenuTesseract getGuiContainer(Player var1) {
        return new ContainerMenuTesseract(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenTesseract((ContainerMenuTesseract)menu);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.getChannels().size());
        customPacketBuffer.writeInt(this.publicChannel.size());
        try {
            EncoderHandler.encode(customPacketBuffer, this.getSlotItem());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Channel channel : this.getChannels()) {
            try {
                EncoderHandler.encode(customPacketBuffer, channel);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.publicChannel = TesseractSystem.instance.getPublicChannels(this.getWorld());
        for (Channel channel : this.publicChannel) {
            try {
                EncoderHandler.encode(customPacketBuffer, channel);
                EncoderHandler.encode(customPacketBuffer, channel.getPos());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        customPacketBuffer.writeBoolean(this.channel != null);
        try {
            EncoderHandler.encode(customPacketBuffer, this.channel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadTesseract(this, this.getWorld()));
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnLoadTesseract(this, this.getWorld()));
        }
        super.onUnloaded();
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        ArrayList<Channel> channels = new ArrayList<Channel>(this.getChannels());
        nbtTagCompound.m_128405_("size", channels.size());
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.get(i);
            nbtTagCompound.m_128365_("channel_" + i, (Tag)channel.writeNBT());
        }
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        int size = nbtTagCompound.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            Channel channel = new Channel(nbtTagCompound.m_128469_("channel_" + i));
            channel.setTesseract(this);
            this.channelList.add(channel);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.tesseract;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        int i;
        super.readContainerPacket(customPacketBuffer);
        this.channelList.clear();
        int size = customPacketBuffer.readInt();
        int size1 = customPacketBuffer.readInt();
        try {
            Inventory inventory = (Inventory)DecoderHandler.decode(customPacketBuffer);
            for (int i2 = 0; i2 < inventory.size(); ++i2) {
                this.slot.set(i2, inventory.get(i2));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < size; ++i) {
            try {
                Channel channel = (Channel)DecoderHandler.decode(customPacketBuffer);
                channel.setTesseract(this);
                this.channelList.add(channel);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.publicChannel.clear();
        for (i = 0; i < size1; ++i) {
            try {
                Channel channel = (Channel)DecoderHandler.decode(customPacketBuffer);
                BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
                ITesseract tesseract = (ITesseract)this.f_58857_.m_7702_(pos);
                channel.setTesseract(tesseract);
                this.publicChannel.add(channel);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        boolean hasChannel = customPacketBuffer.readBoolean();
        if (hasChannel) {
            try {
                this.channel = (Channel)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.channel != null) {
            this.channel.setTesseract(this);
        }
    }

    @Override
    public Channel getChannel(int channel) {
        return this.getChannels().get(channel);
    }

    @Override
    public List<Channel> getChannels() {
        return this.channelList;
    }

    @Override
    public String getPlayer() {
        return this.getComponentPrivate().getPlayers().get(0);
    }

    @Override
    public Energy getEnergy() {
        return this.energy;
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public Inventory getSlotItem() {
        return this.slot;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        switch ((int)var2) {
            case 1: {
                int maxValue1 = 0;
                ArrayList<Integer> integerList1 = new ArrayList<Integer>();
                for (Channel channel1 : this.getChannels()) {
                    integerList1.add(channel1.getChannel());
                }
                while (integerList1.contains(maxValue1)) {
                    ++maxValue1;
                }
                this.channel = new Channel(maxValue1, this, TypeMode.NONE, TypeChannel.NONE, false);
                this.channelList.add(this.channel);
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.getWorld()));
                break;
            }
            case 2: {
                int maxValue2 = 0;
                ArrayList<Integer> integerList2 = new ArrayList<Integer>();
                for (Channel channel1 : this.getChannels()) {
                    integerList2.add(channel1.getChannel());
                }
                while (integerList2.contains(maxValue2) || maxValue2 < this.channel.getChannel()) {
                    ++maxValue2;
                }
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.getWorld()));
                this.channelList.remove(this.channel);
                this.channel = new Channel(maxValue2, this, this.channel.getMode(), this.channel.getTypeChannel(), this.channel.isPrivate());
                this.channelList.add(this.channel);
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.getWorld()));
                break;
            }
            case 3: {
                int maxValue3 = this.channel.getChannel();
                ArrayList<Integer> integerList3 = new ArrayList<Integer>();
                for (Channel channel1 : this.getChannels()) {
                    integerList3.add(channel1.getChannel());
                }
                while (maxValue3 != -1 && integerList3.contains(maxValue3)) {
                    --maxValue3;
                }
                if (maxValue3 == -1) break;
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.getWorld()));
                this.channelList.remove(this.channel);
                this.channel = new Channel(maxValue3, this, this.channel.getMode(), this.channel.getTypeChannel(), this.channel.isPrivate());
                this.channelList.add(this.channel);
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.getWorld()));
                break;
            }
            case 4: {
                var2 -= 4.0;
                var2 *= 10.0;
                var2 = Math.round(var2);
                int mode4 = (int)var2 % 2;
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.getWorld()));
                if (mode4 == 0) {
                    switch (this.channel.getMode()) {
                        case INPUT: {
                            this.channel.setMode(TypeMode.NONE);
                            break;
                        }
                        case OUTPUT: {
                            this.channel.setMode(TypeMode.INOUT);
                            break;
                        }
                        case NONE: {
                            this.channel.setMode(TypeMode.INPUT);
                            break;
                        }
                        case INOUT: {
                            this.channel.setMode(TypeMode.OUTPUT);
                        }
                    }
                } else {
                    switch (this.channel.getMode()) {
                        case OUTPUT: {
                            this.channel.setMode(TypeMode.NONE);
                            break;
                        }
                        case INPUT: {
                            this.channel.setMode(TypeMode.INOUT);
                            break;
                        }
                        case NONE: {
                            this.channel.setMode(TypeMode.OUTPUT);
                            break;
                        }
                        case INOUT: {
                            this.channel.setMode(TypeMode.INPUT);
                        }
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.getWorld()));
                break;
            }
            case 5: {
                var2 -= 5.0;
                var2 *= 10.0;
                var2 = Math.round(var2);
                int mode5 = (int)var2 % 3;
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.getWorld()));
                switch (mode5) {
                    case 0: {
                        this.channel.setTypeChannel(this.channel.getTypeChannel() == TypeChannel.ENERGY ? TypeChannel.NONE : TypeChannel.ENERGY);
                        break;
                    }
                    case 1: {
                        this.channel.setTypeChannel(this.channel.getTypeChannel() == TypeChannel.FLUID ? TypeChannel.NONE : TypeChannel.FLUID);
                        break;
                    }
                    case 2: {
                        this.channel.setTypeChannel(this.channel.getTypeChannel() == TypeChannel.ITEM ? TypeChannel.NONE : TypeChannel.ITEM);
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.getWorld()));
                break;
            }
            case 6: {
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.getWorld()));
                this.channel.setPrivate(!this.channel.isPrivate());
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.getWorld()));
                break;
            }
            case 7: {
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.getWorld()));
                this.channel.setActive(!this.channel.isActive());
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.getWorld()));
                break;
            }
            case 8: {
                this.channel = null;
                break;
            }
            case 9: {
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.getWorld()));
                this.channelList.remove(this.channel);
                this.channel = null;
                break;
            }
            case 10: {
                if ((var2 -= 10.0) == 0.0) {
                    this.channel = this.getChannels().get(0);
                    break;
                }
                int col = (int)(var2 * 10.0);
                var2 *= 10.0;
                var2 -= (double)col;
                for (int i = 0; i < col; ++i) {
                    var2 *= 10.0;
                }
                var2 = Math.round(var2);
                ArrayList<Channel> channels = new ArrayList<Channel>(this.getChannels());
                this.channel = (Channel)channels.get((int)(var2 %= (double)channels.size()));
            }
        }
    }

    public List<Channel> getPublicChannel() {
        return this.publicChannel;
    }
}

