/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.bee;

import com.denfop.IUItem;
import com.denfop.api.bee.Bee;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.bee.BlockEntityApiary;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.items.energy.ItemNet;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityHive
extends BlockEntityBase {
    private final Bee bee;

    public TileEntityHive(Bee bee, MultiBlockEntity tileBlock, BlockPos pos, BlockState state) {
        super(tileBlock, pos, state);
        this.bee = bee;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_21205_().m_41720_() instanceof ItemNet;
        }
        return false;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack stack = new ItemStack((ItemLike)IUItem.jarBees.getStack(0));
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128405_("bee_id", this.bee.getId());
        nbt.m_128405_("swarm", WorldBaseGen.random.nextInt(this.bee.getMaxSwarm() / 2) + 15);
        return Collections.singletonList(stack);
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        return super.getAuxDrops(fortune);
    }

    @Override
    public void onClicked(Player player) {
        if (BlockEntityApiary.hasDamagePlayer) {
            player.m_6469_(IUDamageSource.bee, 5.0f);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }
}

