/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.BlockEntityUpgrade;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuItemDivider;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenItemDivider;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityItemDivider
extends BlockEntityElectricMachine
implements BlockEntityUpgrade,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InventoryUpgrade upgradeSlot;
    public final InventoryRecipes inputSlotA;
    public final Fluids.InternalFluidTank fluidTank1;
    public final Fluids.InternalFluidTank fluidTank2;
    public final InventoryFluidByList fluidSlot1;
    public final InventoryFluidByList fluidSlot2;
    public final InventoryOutput output1;
    public final FluidHandlerRecipe fluid_handler;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    protected short progress;

    public BlockEntityItemDivider(BlockPos pos, BlockState state) {
        super(200.0, 1, 1, BlockBaseMachine3Entity.item_divider, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.progress = 0;
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationLength = 100;
        this.defaultOperationLength = 100;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "item_divider", (IUpdateTick)this);
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTank("fluidTank1", 12000, Inventory.TypeItemSlot.OUTPUT);
        this.output1 = new InventoryOutput(this, 2);
        this.fluidTank2 = fluids.addTank("fluidTank2", 12000, Inventory.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("item_divider", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidTank2.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(1)));
        this.fluidSlot1 = new InventoryFluidByList((BlockEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot2 = new InventoryFluidByList((BlockEntityInventory)this, 1, this.fluid_handler.getOutputFluids(1));
        this.fluidSlot1.setTypeFluidSlot(InventoryFluid.TypeFluidSlot.OUTPUT);
        this.fluidSlot2.setTypeFluidSlot(InventoryFluid.TypeFluidSlot.OUTPUT);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
    }

    public static void addRecipe(ItemStack container, ItemStack output, FluidStack ... fluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("item_divider", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, output)));
        Recipes.recipes.getRecipeFluid().addRecipe("item_divider", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container), Arrays.asList(fluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "200" + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + "1");
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerMenuItemDivider getGuiContainer(Player var1) {
        return new ContainerMenuItemDivider(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenItemDivider((ContainerMenuItemDivider)menu);
    }

    @Override
    public void init() {
        BlockEntityItemDivider.addRecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(456)), new ItemStack((ItemLike)IUItem.iudust.getStack(37)), new FluidStack((Fluid)FluidName.fluidnitrogen.getInstance().get(), 20), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 10));
        BlockEntityItemDivider.addRecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(460)), new ItemStack((ItemLike)IUItem.iudust.getStack(64)), new FluidStack((Fluid)FluidName.fluidnitrogen.getInstance().get(), 20), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 10));
        BlockEntityItemDivider.addRecipe(new ItemStack((ItemLike)IUItem.iudust.getStack(67), 2), new ItemStack((ItemLike)IUItem.iudust.getStack(41), 2), new FluidStack((Fluid)FluidName.fluidsulfuroxide.getInstance().get(), 400), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 100));
        BlockEntityItemDivider.addRecipe(new ItemStack((ItemLike)Items.f_42542_), new ItemStack((ItemLike)Items.f_42593_), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76195_, 60), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 15));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.item_divider;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get(0));
            this.getOutput();
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MutableObject output1 = new MutableObject();
        boolean check = false;
        if (this.fluidTank1.getFluidAmount() >= 1000 && this.fluidSlot1.transferFromTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.output1.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferFromTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.output1.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.fluidTank2.getFluidAmount() >= 1000 && this.fluidSlot2.transferFromTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.output1.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot2.transferFromTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.output1.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (check || this.fluid_handler.output() == null && this.output != null) {
            this.fluid_handler.getOutput(this.inputSlotA.get(0));
        } else if (this.fluid_handler.output() != null && this.output == null) {
            this.fluid_handler.setOutput(null);
        }
        if (this.output != null && !this.inputSlotA.m_7983_() && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items) && this.inputSlotA.continue_process(this.output) && this.fluid_handler.output() != null && this.fluid_handler.canFillFluid() && this.energy.canUseEnergy(this.energyConsume)) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.outputSlot.add(this.output.getRecipe().getOutput().items);
        this.fluid_handler.fillFluid();
    }

    @Override
    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.Processing, new EnumBlockEntityUpgrade[]{EnumBlockEntityUpgrade.Transformer, EnumBlockEntityUpgrade.EnergyStorage, EnumBlockEntityUpgrade.ItemInput, EnumBlockEntityUpgrade.FluidExtract, EnumBlockEntityUpgrade.ItemExtract});
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

