/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.interfaces.EnergySink;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuMachineCharger;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenMachineCharger;
import com.denfop.utils.Localization;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityMachineCharge
extends BlockEntityInventory {
    private final Energy energy;
    private final ComponentVisibleArea visible;
    Map<ChunkPos, List<EnergySink>> chunkPosListMap = new HashMap<ChunkPos, List<EnergySink>>();

    public BlockEntityMachineCharge(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.machine_charger, pos, state);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 1.0E9, 14));
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.machine_charger.info"));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        ChunkPos chunkPos = new ChunkPos(this.pos);
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                int chunkX = (chunkPos.f_45578_ + dx) * 16;
                int chunkZ = (chunkPos.f_45579_ + dz) * 16;
                if (chunkX < minX) {
                    minX = chunkX;
                }
                if (chunkZ < minZ) {
                    minZ = chunkZ;
                }
                if (chunkX + 15 > maxX) {
                    maxX = chunkX + 15;
                }
                if (chunkZ + 15 <= maxZ) continue;
                maxZ = chunkZ + 15;
            }
        }
        this.visible.aabb = new AABB((double)minX, (double)this.f_58857_.m_141937_(), (double)minZ, (double)maxX, (double)this.f_58857_.m_151558_(), (double)maxZ);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.machine_charger;
    }

    public ContainerMenuMachineCharger getGuiContainer(Player var1) {
        return new ContainerMenuMachineCharger(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenMachineCharger((ContainerMenuMachineCharger)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.f_58857_.m_46467_() % 200L == 0L) {
            ChunkPos chunkPos = new ChunkPos(this.pos);
            Map<ChunkPos, List<EnergySink>> map = EnergyNetGlobal.instance.getChunkPosListMap(this.f_58857_);
            this.chunkPosListMap.clear();
            if (map != null) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        ChunkPos chunkPos1 = new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z);
                        List<EnergySink> list = map.get(chunkPos1);
                        if (list == null) continue;
                        this.chunkPosListMap.put(chunkPos1, list);
                    }
                }
            }
            this.chunkPosListMap.get(chunkPos).remove((EnergySink)this.energy.getDelegate());
        }
        if (this.energy.getEnergy() > 0.0) {
            block2: for (Map.Entry<ChunkPos, List<EnergySink>> chunkPosListEntry : this.chunkPosListMap.entrySet()) {
                if (this.energy.getEnergy() == 0.0) break;
                for (EnergySink energySink : chunkPosListEntry.getValue()) {
                    double demanded = energySink.getDemandedEnergy();
                    demanded = Math.min(demanded, this.energy.getEnergy());
                    energySink.receiveEnergy(demanded);
                    this.energy.useEnergy(demanded);
                    if (this.energy.getEnergy() != 0.0) continue;
                    continue block2;
                }
            }
        }
    }

    public Energy getEnergy() {
        return this.energy;
    }
}

