/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.BlockEntityUpgrade;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuPigFarm;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenPigFarm;
import com.denfop.utils.Localization;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityPigFarm
extends BlockEntityInventory
implements BlockEntityUpgrade {
    private static final int RADIUS = 4;
    private static final int MAX_PIGS = 20;
    public final Inventory slotSeeds;
    public final InventoryOutput output;
    public final Energy energy;
    public final InventoryUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    private final ComponentVisibleArea visible;
    AABB searchArea;

    public BlockEntityPigFarm(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.pig_farm, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-4, -4, -4), this.pos.m_7918_(5, 5, 5));
        this.slotSeeds = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == Items.f_42619_;
            }
        };
        this.output = new InventoryOutput(this, 9);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.Transformer, EnumBlockEntityUpgrade.EnergyStorage, EnumBlockEntityUpgrade.ItemExtract, EnumBlockEntityUpgrade.ItemInput);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.pig_farm;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
    }

    public ContainerMenuPigFarm getGuiContainer(Player var1) {
        return new ContainerMenuPigFarm(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenPigFarm((ContainerMenuPigFarm)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            this.energy.useEnergy(50.0);
            List pigs = this.f_58857_.m_45976_(Pig.class, this.searchArea);
            if (pigs.size() < 20) {
                this.breedPigs(pigs);
            }
            this.killOldPigs(pigs);
        }
    }

    private void breedPigs(List<Pig> pigs) {
        block0: for (int i = 0; i < pigs.size(); ++i) {
            for (int j = i + 1; j < pigs.size(); ++j) {
                Pig pig1 = pigs.get(i);
                Pig pig2 = pigs.get(j);
                if (pig1.m_6162_() || pig2.m_6162_() || pig1.m_27593_() || pig2.m_27593_() || this.slotSeeds.get(0).m_41613_() < 2) continue;
                pig1.m_27595_(null);
                pig2.m_27595_(null);
                this.slotSeeds.get(0).m_41774_(2);
                continue block0;
            }
        }
    }

    private void killOldPigs(List<Pig> pigs) {
        for (int i = pigs.size() - 1; i >= 20; --i) {
            Pig pig = pigs.get(i);
            pig.m_142687_(Entity.RemovalReason.KILLED);
            this.output.add(new ItemStack((ItemLike)Items.f_42485_, 1));
        }
    }
}

