/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityBasePlasticCreator;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuPlasticCreator;
import com.denfop.inventory.Inventory;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenPlasticCreator;
import com.denfop.utils.Localization;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class BlockEntityPlasticCreator
extends BlockEntityBasePlasticCreator
implements IHasRecipe {
    public final Inventory input_slot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public BlockEntityPlasticCreator(BlockPos pos, BlockState state) {
        super(1, 300, 1, (MultiBlockEntity)BlockBaseMachine2Entity.plastic_creator, pos, state);
        this.inputSlotA = new InventoryRecipes(this, "plastic", this, this.fluidTank);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.inputSlotA.setInvSlotConsumableLiquidByList(this.fluidSlot);
        this.fluidTank.setTypeItemSlot(Inventory.TypeItemSlot.INPUT);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        Recipes.recipes.addInitRecipes(this);
        this.input_slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).m_41619_()) {
                    ((BlockEntityPlasticCreator)this.base).inputSlotA.changeAccepts(ItemStack.f_41583_);
                } else {
                    ((BlockEntityPlasticCreator)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
    }

    private static void spawnParticles(Level level, double x, double y, double z) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.3, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.1, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y - 0.1, z, 0.0, 0.025, 0.0);
    }

    private static void spawnFlame(Level level, double x, double y, double z) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.025, 0.0);
    }

    public ContainerMenuPlasticCreator getGuiContainer(Player entityPlayer) {
        return new ContainerMenuPlasticCreator(entityPlayer, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            if (this.input_slot.m_7983_()) {
                this.inputSlotA.changeAccepts(ItemStack.f_41583_);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine2Entity.plastic_creator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)Fluids.f_76193_, 1000), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(483), 1)), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(484), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.plast.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)Fluids.f_76193_, 1000), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getStack(38), 1)), input.getInput("forge:dusts/Coal", 4)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iudust.getStack(39), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidhelium.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.cooling_mixture.getItem())), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(386), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.helium_cooling_mixture.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidcryogen.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.helium_cooling_mixture.getItem())), input.getInput(new ItemStack((ItemLike)IUItem.radiationresources.getStack(3), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.cryogenic_cooling_mixture.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidnitrogen.getInstance().get(), 12000), input.getInput("forge:storage_blocks/Vitalium"), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(269), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(270), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidpolyeth.getInstance().get(), 500), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(344), 1)), input.getInput("forge:doubleplate/Titanium")), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(340), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidpetroleum.getInstance().get(), 5000), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(283), 8)), input.getInput("forge:ingots/Germanium", 4)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(386), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidtrinitrotoluene.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)Items.f_42403_, 4)), input.getInput(new ItemStack((ItemLike)Items.f_42525_, 3))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iudust.getStack(72), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidsulfuricacid.getInstance().get(), 100), input.getInput(new ItemStack((ItemLike)IUItem.classic_ore.getItem(3), 4)), input.getInput(IUItem.stoneDust, 2)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(21), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidnitricacid.getInstance().get(), 100), input.getInput(new ItemStack((ItemLike)IUItem.toriyore.getItem(0))), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getStack(54), 2), 2)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(16), 9))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.beeswax.getItem())), input.getInput(new ItemStack((ItemLike)Items.f_42398_), 2)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.wax_stick.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidhoney.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.wax_stick.getItem())), input.getInput(new ItemStack((ItemLike)IUItem.royal_jelly.getItem()), 1)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.polished_stick.getItem()))));
        for (int i = 0; i < 14; ++i) {
            Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidtemperedglass.getInstance().get(), 144), input.getInput(new ItemStack((ItemLike)IUItem.solar_day_glass.getStack(i), 1)), input.getInput(new ItemStack((ItemLike)IUItem.solar_night_glass.getStack(i), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.solar_night_day_glass.getStack(i), 1))));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive() && this.getWorld().m_46467_() % 5L == 0L) {
            double x = this.pos.m_123341_();
            double y = this.pos.m_123342_();
            double z = this.pos.m_123343_();
            switch (this.getFacing()) {
                case NORTH: {
                    BlockEntityPlasticCreator.spawnParticles(this.f_58857_, x + 0.8, y + 1.2, z + 0.8);
                    BlockEntityPlasticCreator.spawnParticles(this.f_58857_, x + 0.2, y + 1.2, z + 0.8);
                    break;
                }
                case SOUTH: {
                    BlockEntityPlasticCreator.spawnFlame(this.f_58857_, x + 0.5, y + 1.2, z);
                    BlockEntityPlasticCreator.spawnFlame(this.f_58857_, x + 0.5, y + 1.2, z + 0.3);
                    BlockEntityPlasticCreator.spawnFlame(this.f_58857_, x + 0.7, y + 1.2, z + 0.3);
                    BlockEntityPlasticCreator.spawnFlame(this.f_58857_, x + 0.3, y + 1.2, z + 0.3);
                    break;
                }
                case WEST: {
                    BlockEntityPlasticCreator.spawnParticles(this.f_58857_, x + 0.8, y + 1.2, z + 0.8);
                    BlockEntityPlasticCreator.spawnParticles(this.f_58857_, x + 0.8, y + 1.2, z + 0.2);
                    break;
                }
                case EAST: {
                    BlockEntityPlasticCreator.spawnParticles(this.f_58857_, x + 0.2, y + 1.2, z + 0.8);
                    BlockEntityPlasticCreator.spawnParticles(this.f_58857_, x + 0.2, y + 1.2, z + 0.2);
                }
            }
        }
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockPlasticCreator.name");
    }

    @Override
    public int gaugeLiquidScaled(int i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0 : this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenPlasticCreator((ContainerMenuPlasticCreator)isAdmin);
    }

    @Override
    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.Processing, new EnumBlockEntityUpgrade[]{EnumBlockEntityUpgrade.Transformer, EnumBlockEntityUpgrade.EnergyStorage, EnumBlockEntityUpgrade.ItemExtract, EnumBlockEntityUpgrade.ItemInput, EnumBlockEntityUpgrade.FluidExtract});
    }
}

