/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalLaserPolisherEntity;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockEntityPrimalLaserPolisher
extends BlockEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InventoryRecipes inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "primal_laser_polisher", (IUpdateTick)this);
    public final InventoryOutput outputSlot = new InventoryOutput(this, 1);
    public int progress = 0;
    public MachineRecipe output;
    public int tick = 0;
    public Map<UUID, Double> data;

    public BlockEntityPrimalLaserPolisher(BlockPos pos, BlockState state) {
        super(BlockPrimalLaserPolisherEntity.primal_laser_polisher, pos, state);
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair3"));
        tooltip.add(Localization.translate("iu.primal_repair6"));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.primalPolisher.getBlock();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockPrimalLaserPolisherEntity.primal_laser_polisher;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.LASER);
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((Inventory)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.f_41583_);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.f_41583_);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.outputSlot.readFromNbt(((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.setActive(!this.inputSlotA.m_7983_());
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == IUItem.laser.getItem() && this.output != null && this.outputSlot.m_7983_() && this.getWorld().m_46461_()) {
            this.progress += (short)(5 + (short)(this.data.getOrDefault(player.m_20148_(), 0.0) / 10.0));
            this.getCooldownTracker().setTick(10);
            if (this.progress >= 100) {
                this.progress = 0;
                player.m_21008_(hand, stack.m_41720_().getCraftingRemainingItem(stack));
                if (!this.getWorld().f_46443_) {
                    PrimitiveHandler.addExperience(EnumPrimitive.LASER, 0.5, player.m_20148_());
                }
                this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (this.inputSlotA.m_7983_() || this.outputSlot.get(0).m_41613_() >= 64) {
                    this.output = null;
                }
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                }
            }
            return true;
        }
        if (!stack.m_41619_()) {
            if (this.inputSlotA.get(0).m_41619_() && this.inputSlotA.m_7013_(0, stack)) {
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                this.inputSlotA.set(0, stack1);
                this.output = this.inputSlotA.process();
                stack.m_41774_(1);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
            if (!this.outputSlot.m_7983_()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
                }
                this.outputSlot.set(0, ItemStack.f_41583_);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.m_7983_()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
                }
                this.outputSlot.set(0, ItemStack.f_41583_);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.m_7983_()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.f_41583_);
                this.output = null;
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(493)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(495)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(0)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(0)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(1)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(1)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(2)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(2)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(3)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(3)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(4)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(6)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(5)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(7)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(6)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(8)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(7)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(9)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(8)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(10)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(9)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(11)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(10)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(12)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(10)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(12)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(11)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(14)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(12)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(15)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(13)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(16)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(14)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(17)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(15)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(18)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(16)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.f_151052_))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(17)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.f_42417_, 1))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(18)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.f_42416_, 1))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(19)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(22)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(20)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(24)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(22)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(25)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(23)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(26)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(24)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(27)))));
        for (int i = 25; i < 40; ++i) {
            Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(i)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(i + 3)))));
        }
    }
}

