/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.sound.EnumTypeAudio;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalWireInsulatorEntity;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityPrimalWireInsulator
extends BlockEntityInventory
implements IUpdateTick,
AudioFixer {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 1.25, 1.0));
    public final InventoryRecipes inputSlotA;
    public final InventoryOutput outputSlot;
    public int progress = 0;
    public MachineRecipe output;
    public Map<UUID, Double> data = PrimitiveHandler.getPlayersData(EnumPrimitive.WIRE_INSULATOR);

    public BlockEntityPrimalWireInsulator(BlockPos pos, BlockState state) {
        super(BlockPrimalWireInsulatorEntity.primal_wire_insulator, pos, state);
        this.inputSlotA = new InventoryRecipes(this, "wire_insulator", this){

            @Override
            public int getStackSizeLimit() {
                if (BlockEntityPrimalWireInsulator.this.output == null) {
                    return 1;
                }
                return BlockEntityPrimalWireInsulator.this.output.getRecipe().input.getInputs().get(0).getAmount();
            }
        };
        this.outputSlot = new InventoryOutput(this, 1){

            @Override
            public int getStackSizeLimit() {
                return 1;
            }
        };
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 4; ++i) {
            tooltip.add(Localization.translate("wire_insulator.info" + i));
        }
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        ItemStack stack = drop.get(0);
        return drop;
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockwireinsulator.getBlock();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockPrimalWireInsulatorEntity.primal_wire_insulator;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            this.getWorld().m_5594_(null, this.pos, this.getSound(), SoundSource.BLOCKS, 64.0f, 1.0f);
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.WIRE_INSULATOR);
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((Inventory)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.f_41583_);
            this.inputSlotA.set(1, ItemStack.f_41583_);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.f_41583_);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.outputSlot.readFromNbt(((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getWorld().f_46443_) {
            if (stack.m_41720_() == IUItem.cutter.getItem() && this.output != null && this.outputSlot.m_7983_() && this.inputSlotA.continue_process(this.output)) {
                this.getCooldownTracker().setTick(10);
                this.progress += (short)(20 + (short)(this.data.getOrDefault(player.m_20148_(), 0.0) / 3.3));
                if (!this.getWorld().f_46443_) {
                    this.initiate(0);
                }
                if (this.progress >= 100) {
                    this.progress = 0;
                    this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                    if (!this.getWorld().f_46443_) {
                        PrimitiveHandler.addExperience(EnumPrimitive.WIRE_INSULATOR, 0.5, player.m_20148_());
                    }
                    this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                    this.inputSlotA.consume(1, this.output.getRecipe().input.getInputs().get(1).getAmount());
                    this.output = null;
                    player.m_21008_(hand, stack.m_41720_().getCraftingRemainingItem(stack));
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                    }
                }
                return this.getWorld().f_46443_;
            }
            if (!stack.m_41619_() && this.outputSlot.m_7983_()) {
                if (this.inputSlotA.get(0).m_41619_() && this.inputSlotA.m_7013_(0, stack)) {
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(1);
                    this.inputSlotA.set(0, stack1);
                    stack.m_41774_(1);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
                if (!this.inputSlotA.get(0).m_41619_() && this.inputSlotA.get(0).m_150930_(stack.m_41720_())) {
                    int minCount = this.inputSlotA.getStackSizeLimit() - this.inputSlotA.get(0).m_41613_();
                    minCount = Math.min(stack.m_41613_(), minCount);
                    this.inputSlotA.get(0).m_41769_(minCount);
                    stack.m_41769_(-minCount);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
                if (this.inputSlotA.get(1).m_41619_() && this.inputSlotA.m_7013_(1, stack)) {
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(1);
                    this.inputSlotA.set(1, stack1);
                    stack.m_41774_(1);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
                if (!this.inputSlotA.get(1).m_41619_() && this.inputSlotA.get(1).m_150930_(stack.m_41720_())) {
                    int minCount = this.inputSlotA.getStackSizeLimit() - this.inputSlotA.get(1).m_41613_();
                    minCount = Math.min(stack.m_41613_(), minCount);
                    this.inputSlotA.get(1).m_41769_(minCount);
                    stack.m_41769_(-minCount);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
            } else {
                if (!this.outputSlot.m_7983_()) {
                    if (!this.f_58857_.f_46443_) {
                        ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
                    }
                    this.outputSlot.set(0, ItemStack.f_41583_);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot2", false);
                    }
                    this.changeState();
                    return true;
                }
                if (!this.inputSlotA.m_7983_()) {
                    if (!this.f_58857_.f_46443_) {
                        ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(0));
                        ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(1));
                    }
                    this.inputSlotA.set(0, ItemStack.f_41583_);
                    this.inputSlotA.set(1, ItemStack.f_41583_);
                    this.output = null;
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot3", false);
                    }
                    this.changeState();
                    return true;
                }
            }
        }
        return this.f_58857_.f_46443_;
    }

    private void changeState() {
        ItemStack input = this.inputSlotA.get(0);
        ItemStack input1 = this.inputSlotA.get(1);
        if (this.outputSlot.m_7983_()) {
            if (!input.m_41619_()) {
                if (input1.m_41619_()) {
                    switch (IUItem.cable.getMetaFromItemStack(input)) {
                        case 11: {
                            this.setActive("copper");
                            break;
                        }
                        case 14: {
                            this.setActive("gold");
                            break;
                        }
                        case 16: {
                            this.setActive("iron");
                            break;
                        }
                        case 18: {
                            this.setActive("tin");
                        }
                    }
                } else {
                    switch (IUItem.cable.getMetaFromItemStack(input)) {
                        case 11: {
                            this.setActive("copper_final");
                            break;
                        }
                        case 14: {
                            this.setActive("gold_final");
                            break;
                        }
                        case 16: {
                            this.setActive("iron_final");
                            break;
                        }
                        case 18: {
                            this.setActive("tin_final");
                        }
                    }
                }
            } else {
                this.setActive("");
            }
        } else {
            switch (IUItem.cable.getMetaFromItemStack(this.outputSlot.get(0))) {
                case 12: {
                    this.setActive("copper_final");
                    break;
                }
                case 15: {
                    this.setActive("gold_final");
                    break;
                }
                case 17: {
                    this.setActive("iron_final");
                    break;
                }
                case 19: {
                    this.setActive("tin_final");
                }
            }
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

