/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.upgrades.BlockEntityUpgrade;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuRefrigerator;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryTank;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.items.reactors.ItemReactorCoolant;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenRefrigerator;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityRefrigeratorCoolant
extends BlockEntityElectricMachine
implements BlockEntityUpgrade,
IUpdatableTileEvent {
    public final InventoryUpgrade upgradeSlot = new InventoryUpgrade(this, 4);
    public final Fluids fluids = this.addComponent(new Fluids(this));
    public final Fluids.InternalFluidTank tank = this.fluids.addTankInsert("input", 10000, Fluids.fluidPredicate((Fluid)FluidName.fluidhelium.getInstance().get(), (Fluid)FluidName.fluidhydrogen.getInstance().get(), (Fluid)FluidName.fluidnitrogen.getInstance().get()));
    public final Inventory slot;
    public final InventoryTank fluidSlot;

    public BlockEntityRefrigeratorCoolant(BlockPos pos, BlockState state) {
        super(400.0, 14, 1, BlockBaseMachine3Entity.refrigerator_coolant, pos, state);
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof ItemReactorCoolant;
            }
        };
        this.slot.setStackSizeLimit(1);
        this.fluidSlot = new InventoryTank(this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.INPUT, (IFluidTank)this.tank);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.refrigerator_coolant;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerMenuRefrigerator getGuiContainer(Player var1) {
        return new ContainerMenuRefrigerator(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenRefrigerator((ContainerMenuRefrigerator)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.fluidSlot.m_7983_() && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity() && !this.fluidSlot.get(0).m_41619_() && this.fluidSlot.processIntoTank((IFluidTank)this.tank, this.outputSlot)) {
            this.upgradeSlot.tickNoMark();
        }
        if (this.energy.getEnergy() >= 50.0 && !this.slot.m_7983_() && this.tank.getFluidAmount() > 1) {
            ItemReactorCoolant coolant = (ItemReactorCoolant)this.slot.get(0).m_41720_();
            int need = coolant.needFill(this.slot.get(0));
            if (coolant == IUItem.coolant.getItem() && this.tank.getFluid().getFluid() == FluidName.fluidhydrogen.getInstance().get() && need > 0) {
                coolant.fill(this.slot.get(0));
                this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.setActive(true);
                this.energy.useEnergy(50.0);
            } else if (coolant == IUItem.adv_coolant.getItem() && this.tank.getFluid().getFluid() == FluidName.fluidnitrogen.getInstance().get() && need > 0) {
                coolant.fill(this.slot.get(0));
                this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.setActive(true);
                this.energy.useEnergy(50.0);
            } else if (coolant == IUItem.imp_coolant.getItem() && this.tank.getFluid().getFluid() == FluidName.fluidhelium.getInstance().get() && need > 0) {
                coolant.fill(this.slot.get(0));
                this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.setActive(true);
                this.energy.useEnergy(50.0);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.upgradeSlot.tickNoMark();
    }

    @Override
    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.Transformer, EnumBlockEntityUpgrade.EnergyStorage, EnumBlockEntityUpgrade.FluidInput);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }
}

