/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.BlockEntityUpgrade;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuRodManufacturer;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenRodManufacturer;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityRodManufacturer
extends BlockEntityInventory
implements BlockEntityUpgrade,
IUpdateTick,
IHasRecipe {
    public final InventoryRecipes inputSlotA;
    public final Energy energy;
    public final InventoryUpgrade upgradeSlot;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final InventoryOutput outputSlot = new InventoryOutput(this, 1);
    public final Inventory input_slot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public MachineRecipe output = null;
    public short progress;
    public double guiProgress;
    public double energyConsume = 2.0;
    public int operationLength = 300;
    public int operationsPerTick = 1;

    public BlockEntityRodManufacturer(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.rods_manufacturer, pos, state);
        this.defaultEnergyConsume = 2.0;
        this.defaultOperationLength = 300;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 600.0;
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, this.defaultEnergyStorage, this.defaultTier));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "rod_assembler", (IUpdateTick)this);
        this.inputSlotA.setStackSizeLimit(1);
        Recipes.recipes.addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.05));
        this.input_slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).m_41619_()) {
                    ((BlockEntityRodManufacturer)this.base).inputSlotA.changeAccepts(ItemStack.f_41583_);
                } else {
                    ((BlockEntityRodManufacturer)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
    }

    public static void addRecipe(ItemStack input, ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4, ItemStack input5, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input2), recipeInputFactory.getInput(input3), recipeInputFactory.getInput(input4), recipeInputFactory.getInput(input5)), new RecipeOutput(null, output)));
    }

    public static void addRecipe(String input, String input1, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(input), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1)), new RecipeOutput(null, output)));
    }

    public static void addRecipe1(String input, String input1, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(input), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1)), new RecipeOutput(null, output)));
    }

    public static void addRecipe2(String input, String input1, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1)), new RecipeOutput(null, output)));
    }

    public static void addRecipe(ItemStack stack1, String input, String input1, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(stack1), recipeInputFactory.getInput(stack1), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input)), new RecipeOutput(null, output)));
    }

    public static void addRecipe1(ItemStack stack1, String input, String input1, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(output), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input)), new RecipeOutput(null, stack1)));
    }

    public static void addRecipe(ItemStack stack1, ItemStack input, String input1, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(stack1), recipeInputFactory.getInput(stack1), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input)), new RecipeOutput(null, output)));
    }

    public static void addRecipe1(ItemStack stack1, ItemStack input, String input1, ItemStack output) {
        IInputHandler recipeInputFactory = Recipes.inputFactory;
        Recipes.recipes.addRecipe("rod_assembler", new BaseMachineRecipe(new Input(recipeInputFactory.getInput(stack1), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input1), recipeInputFactory.getInput(input)), new RecipeOutput(null, output)));
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.rods_manufacturer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void init() {
        BlockEntityRodManufacturer.addRecipe("logs", "planks", new ItemStack((ItemLike)IUItem.windrod.getStack(0)));
        BlockEntityRodManufacturer.addRecipe1("logs", "planks", new ItemStack((ItemLike)IUItem.water_rod.getStack(0)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(0)), "forge:plates/Bronze", "forge:casings/Bronze", new ItemStack((ItemLike)IUItem.windrod.getStack(1)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(1)), "forge:plates/Iron", "forge:casings/Iron", new ItemStack((ItemLike)IUItem.windrod.getStack(2)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(2)), "forge:plates/Steel", "forge:casings/Steel", new ItemStack((ItemLike)IUItem.windrod.getStack(3)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(3)), "forge:plates/Carbon", "forge:plates/Carbon", new ItemStack((ItemLike)IUItem.windrod.getStack(4)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(4)), "forge:plates/Iridium", "forge:casings/Iridium", new ItemStack((ItemLike)IUItem.windrod.getStack(5)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(5)), IUItem.iridiumOre, "forge:doubleplate/Iridium", new ItemStack((ItemLike)IUItem.windrod.getStack(6)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(6)), "forge:plates/Electrum", "forge:casings/Electrum", new ItemStack((ItemLike)IUItem.windrod.getStack(7)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(7)), "forge:crystal/Proton", "forge:crystal/Photon", new ItemStack((ItemLike)IUItem.windrod.getStack(8)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(8)), "forge:crystal/Photon", "forge:crystalingot/Photon", new ItemStack((ItemLike)IUItem.windrod.getStack(10), 1));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(10)), "forge:nuggets/Neutron", "forge:casings/Vitalium", new ItemStack((ItemLike)IUItem.windrod.getStack(9)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(9)), "forge:plates/Spinel", "forge:casings/Spinel", new ItemStack((ItemLike)IUItem.windrod.getStack(11)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(11)), "forge:plates/Cobalt", "forge:casings/Cobalt", new ItemStack((ItemLike)IUItem.windrod.getStack(12)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.windrod.getStack(12)), "forge:plates/Mikhail", "forge:casings/Mikhail", new ItemStack((ItemLike)IUItem.windrod.getStack(13)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(0)), "forge:plates/Bronze", "forge:casings/Bronze", new ItemStack((ItemLike)IUItem.water_rod.getStack(1)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(1)), "forge:plates/Iron", "forge:casings/Iron", new ItemStack((ItemLike)IUItem.water_rod.getStack(2)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(2)), "forge:plates/Steel", "forge:casings/Steel", new ItemStack((ItemLike)IUItem.water_rod.getStack(3)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(3)), "forge:plates/Carbon", "forge:plates/Carbon", new ItemStack((ItemLike)IUItem.water_rod.getStack(4)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(4)), "forge:plates/Iridium", "forge:casings/Iridium", new ItemStack((ItemLike)IUItem.water_rod.getStack(5)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(5)), IUItem.iridiumOre, "forge:doubleplate/Iridium", new ItemStack((ItemLike)IUItem.water_rod.getStack(6)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(6)), "forge:plates/Electrum", "forge:casings/Electrum", new ItemStack((ItemLike)IUItem.water_rod.getStack(7)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(7)), "forge:crystal/Proton", "forge:crystal/Photon", new ItemStack((ItemLike)IUItem.water_rod.getStack(8)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(8)), "forge:crystal/Photon", "forge:crystalingot/Photon", new ItemStack((ItemLike)IUItem.water_rod.getStack(10), 1));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(10)), "forge:nuggets/Neutron", "forge:casings/Vitalium", new ItemStack((ItemLike)IUItem.water_rod.getStack(9)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(9)), "forge:plates/Spinel", "forge:casings/Spinel", new ItemStack((ItemLike)IUItem.water_rod.getStack(11)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(11)), "forge:plates/Cobalt", "forge:casings/Cobalt", new ItemStack((ItemLike)IUItem.water_rod.getStack(12)));
        BlockEntityRodManufacturer.addRecipe(new ItemStack((ItemLike)IUItem.water_rod.getStack(12)), "forge:plates/Mikhail", "forge:casings/Mikhail", new ItemStack((ItemLike)IUItem.water_rod.getStack(13)));
        BlockEntityRodManufacturer.addRecipe2("logs", "planks", new ItemStack((ItemLike)IUItem.wood_steam_blade.getItem()));
        BlockEntityRodManufacturer.addRecipe1(new ItemStack((ItemLike)IUItem.bronze_steam_blade.getItem(), 1), "forge:plates/Bronze", "forge:casings/Bronze", new ItemStack((ItemLike)IUItem.wood_steam_blade.getItem()));
        BlockEntityRodManufacturer.addRecipe1(new ItemStack((ItemLike)IUItem.iron_steam_blade.getItem(), 1), "forge:plates/Iron", "forge:casings/Iron", new ItemStack((ItemLike)IUItem.bronze_steam_blade.getItem()));
        BlockEntityRodManufacturer.addRecipe1(new ItemStack((ItemLike)IUItem.steel_steam_blade.getItem(), 1), "forge:plates/Steel", "forge:casings/Steel", new ItemStack((ItemLike)IUItem.iron_steam_blade.getItem()));
        BlockEntityRodManufacturer.addRecipe1(new ItemStack((ItemLike)IUItem.carbon_steam_blade.getItem(), 1), "forge:plates/Carbon", "forge:plates/Carbon", new ItemStack((ItemLike)IUItem.steel_steam_blade.getItem()));
        BlockEntityRodManufacturer.addRecipe1(IUItem.iridium_steam_blade.getItemStack(), "forge:plates/Iridium", "forge:casings/Iridium", new ItemStack((ItemLike)IUItem.carbon_steam_blade.getItem()));
        BlockEntityRodManufacturer.addRecipe1(IUItem.iridium_steam_blade.getItemStack(), IUItem.iridiumOre, "forge:doubleplate/Iridium", IUItem.compressiridium_steam_blade.getItemStack());
        BlockEntityRodManufacturer.addRecipe1(IUItem.spectral_steam_blade.getItemStack(), "forge:plates/Electrum", "forge:casings/Electrum", IUItem.compressiridium_steam_blade.getItemStack());
        BlockEntityRodManufacturer.addRecipe1(IUItem.myphical_steam_blade.getItemStack(), "forge:crystal/Proton", "forge:crystal/Photon", IUItem.spectral_steam_blade.getItemStack());
        BlockEntityRodManufacturer.addRecipe1(IUItem.photon_steam_blade.getItemStack(), "forge:crystal/Photon", "forge:crystalingot/Photon", IUItem.myphical_steam_blade.getItemStack());
        BlockEntityRodManufacturer.addRecipe1(IUItem.neutron_steam_blade.getItemStack(), "forge:nuggets/Neutron", "forge:casings/Vitalium", IUItem.photon_steam_blade.getItemStack());
        BlockEntityRodManufacturer.addRecipe1(IUItem.barion_steam_blade.getItemStack(), "forge:plates/Spinel", "forge:casings/Spinel", IUItem.neutron_steam_blade.getItemStack());
        BlockEntityRodManufacturer.addRecipe1(IUItem.hadron_steam_blade.getItemStack(), "forge:plates/Cobalt", "forge:casings/Cobalt", IUItem.barion_steam_blade.getItemStack());
        BlockEntityRodManufacturer.addRecipe1(IUItem.ultramarine_steam_blade.getItemStack(), "forge:plates/Mikhail", "forge:casings/Mikhail", IUItem.hadron_steam_blade.getItemStack());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.setOverclockRates();
            this.inputSlotA.load();
            if (this.input_slot.m_7983_()) {
                this.inputSlotA.changeAccepts(ItemStack.f_41583_);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
            this.getOutput();
        }
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate(MachineRecipe output) {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            List<ItemStack> processResult = output.getRecipe().output.items;
            this.operateOnce(processResult);
            if (!this.inputSlotA.continue_process(this.output) || !this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.getOutput();
                break;
            }
            if (this.output == null) break;
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.output;
        if (this.output != null && this.energy.canUseEnergy(this.energyConsume) && !this.inputSlotA.m_7983_() && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items)) {
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate(output);
                this.progress = 0;
            }
        } else if (output == null) {
            this.progress = 0;
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.inputSlotA.consume();
        this.outputSlot.add(processResult);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.Processing, EnumBlockEntityUpgrade.Transformer, EnumBlockEntityUpgrade.EnergyStorage, EnumBlockEntityUpgrade.ItemExtract, EnumBlockEntityUpgrade.ItemInput);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public ContainerMenuRodManufacturer getGuiContainer(Player entityPlayer) {
        return new ContainerMenuRodManufacturer(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenRodManufacturer((ContainerMenuRodManufacturer)menu);
    }
}

