/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuWirelessControllerReactors;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemReactorData;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenWirelessControllerReactors;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityWirelessControllerReactors
extends BlockEntityInventory
implements IUpdatableTileEvent {
    public final Inventory invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<BlockEntityMultiBlockBase> tileMultiBlockBaseList = new LinkedList<BlockEntityMultiBlockBase>();

    public BlockEntityWirelessControllerReactors(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.wireless_controller_reactors, pos, state);
        this.invslot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 12){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                BlockEntityWirelessControllerReactors.this.updateList();
                return content;
            }

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                if (!(stack.m_41720_() instanceof ItemReactorData)) {
                    return false;
                }
                CompoundTag nbt = ModUtils.nbt(stack);
                return !nbt.m_128461_("name").isEmpty();
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerMenuWirelessControllerReactors getGuiContainer(Player var1) {
        return new ContainerMenuWirelessControllerReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenWirelessControllerReactors((ContainerMenuWirelessControllerReactors)menu);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.wireless_controller_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.tileMultiBlockBaseList.clear();
        this.itemStacks.clear();
        for (int i = 0; i < 12; ++i) {
            CompoundTag nbt = ModUtils.nbt(this.invslot.get(i));
            BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            BlockEntity tileEntity = this.getWorld().m_7702_(pos);
            if (tileEntity instanceof BlockEntityMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((BlockEntityMultiBlockBase)tileEntity);
                this.itemStacks.add(((BlockEntityMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.f_41583_);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.tileMultiBlockBaseList.clear();
        for (int i = 0; i < 12; ++i) {
            CompoundTag nbt = ModUtils.nbt(this.invslot.get(i));
            BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            BlockEntity tileEntity = this.getWorld().m_7702_(pos);
            if (tileEntity instanceof BlockEntityMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((BlockEntityMultiBlockBase)tileEntity);
                this.itemStacks.add(((BlockEntityMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.f_41583_);
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        BlockEntityMultiBlockBase tileMultiBlockBase;
        if (!this.itemStacks.get((int)var2).m_41619_() && (tileMultiBlockBase = this.tileMultiBlockBaseList.get((int)var2)) != null && tileMultiBlockBase.isFull() && !tileMultiBlockBase.m_58901_()) {
            tileMultiBlockBase.onActivated(var1, var1.m_7655_(), Direction.NORTH, new Vec3(0.0, 0.0, 0.0));
        }
    }
}

