/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.multiblocks.base;

import com.denfop.IUCore;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.multiblock.MainMultiBlock;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.mixin.access.LevelRendererAccessor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public abstract class BlockEntityMultiBlockBase
extends BlockEntityInventory
implements MainMultiBlock,
IUpdatableTileEvent {
    public boolean full;
    public boolean activate;
    public List<Player> entityPlayerList;
    private MultiBlockStructure multiBlockStructure;
    private boolean visible = true;
    @OnlyIn(value=Dist.CLIENT)
    private Function render;

    public BlockEntityMultiBlockBase(MultiBlockStructure multiBlockStructure, MultiBlockEntity multiTileBlock, BlockPos pos, BlockState state) {
        super(multiTileBlock, pos, state);
        this.multiBlockStructure = multiBlockStructure;
        this.full = false;
        this.entityPlayerList = new ArrayList<Player>();
        this.activate = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Function<RenderLevelStageEvent, Void> createFunction(BlockEntityMultiBlockBase te) {
        Function<RenderLevelStageEvent, Void> function = o -> {
            PoseStack poseStack = o.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)te.m_58899_().m_123341_() + 0.5f), (double)te.m_58899_().m_123342_(), (double)((float)te.m_58899_().m_123343_() + 0.5f));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            te.render(te, (RenderLevelStageEvent)o);
            poseStack.m_85849_();
            return null;
        };
        return function;
    }

    @Override
    public int getBlockLevel() {
        return 0;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        if (!this.isFull()) {
            this.updateFull();
            this.full = true;
            this.activate = true;
        }
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        block7: {
            super.addInformation(stack, tooltip);
            tooltip.add(Localization.translate("iu.multiblock.info_visible_structure"));
            if (this.f_58857_ != null) break block7;
            tooltip.add(Localization.translate("multiblock.jei1"));
            if (this.getMultiBlockStucture() != null) {
                for (ItemStack stack1 : this.getMultiBlockStucture().itemStackList) {
                    if (stack1.m_41619_()) continue;
                    tooltip.add(ChatFormatting.GREEN + stack1.m_41613_() + "x" + ChatFormatting.GRAY + stack1.m_41611_().getString());
                }
            } else {
                try {
                    this.multiBlockStructure = ((BlockEntityMultiBlockBase)this.getTeBlock().getTeClass().getConstructors()[0].newInstance((Object[])new Object[]{BlockPos.f_121853_, this.m_58900_()})).multiBlockStructure;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Direction rotateFacing(Direction original, Direction baseRotation) {
        if (original == Direction.UP || original == Direction.DOWN) {
            return original;
        }
        switch (baseRotation) {
            case EAST: {
                return this.rotate90(original);
            }
            case WEST: {
                return this.rotate90(this.rotate90(this.rotate90(original)));
            }
            case SOUTH: {
                return this.rotate90(this.rotate90(original));
            }
        }
        return original;
    }

    private Direction rotate90(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return facing;
    }

    public MultiBlockStructure getMultiBlockStructure() {
        return this.multiBlockStructure;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.full);
            EncoderHandler.encode(packet, this.activate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onRemovedByPlayer(Player player, boolean willHarvest) {
        return true;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.full = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.activate = (Boolean)DecoderHandler.decode(customPacketBuffer);
            if (this.full && this.activate) {
                this.updateFull();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void updateAfterAssembly();

    public abstract void usingBeforeGUI();

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntityMultiBlockBase tileEntityMultiBlockBase, RenderLevelStageEvent event) {
        if (!this.isFull()) {
            this.renderBlock(tileEntityMultiBlockBase, event);
        } else if (this.getMultiBlockStucture().hasUniqueModels) {
            this.renderUniqueMultiBlock(event);
        }
    }

    private void rotateBlocks() {
        for (Map.Entry<BlockPos, Direction> entry : this.multiBlockStructure.RotationMap.entrySet()) {
            BlockEntityMultiBlockElement multiBlockElement;
            Direction rotation = entry.getValue();
            BlockPos pos1 = switch (this.getFacing()) {
                case Direction.NORTH -> entry.getKey();
                case Direction.EAST -> new BlockPos(-entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_());
                case Direction.WEST -> new BlockPos(entry.getKey().m_123343_(), entry.getKey().m_123342_(), -entry.getKey().m_123341_());
                case Direction.SOUTH -> new BlockPos(-entry.getKey().m_123341_(), entry.getKey().m_123342_(), -entry.getKey().m_123343_());
                default -> throw new IllegalStateException("Unexpected value: " + this.getFacing());
            };
            Direction facing = this.getFacing();
            if ((pos1 = this.pos.m_121955_((Vec3i)pos1)).equals((Object)this.pos)) continue;
            if (facing == Direction.NORTH) {
                if (rotation == Direction.EAST || rotation == Direction.WEST) {
                    rotation = rotation.m_122424_();
                }
            } else if (facing == Direction.SOUTH) {
                if (rotation == Direction.SOUTH || rotation == Direction.NORTH) {
                    rotation = rotation.m_122424_();
                }
            } else if (facing == Direction.EAST) {
                rotation = rotation == Direction.EAST || rotation == Direction.WEST ? (rotation == Direction.EAST ? Direction.NORTH : Direction.SOUTH) : (rotation == Direction.SOUTH ? Direction.WEST : Direction.EAST);
            } else if (facing == Direction.WEST) {
                rotation = rotation == Direction.EAST || rotation == Direction.WEST ? (rotation == Direction.WEST ? Direction.NORTH : Direction.SOUTH) : (rotation == Direction.SOUTH ? Direction.EAST : Direction.WEST);
            }
            if ((multiBlockElement = (BlockEntityMultiBlockElement)this.getWorld().m_7702_(pos1)) == null) continue;
            multiBlockElement.setFacing(rotation);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(BlockEntityMultiBlockBase tile, RenderLevelStageEvent event) {
        if (this.facing == 0 || this.facing == 1 || !this.visible) {
            return;
        }
        for (Map.Entry<BlockPos, ItemStack> entry : this.multiBlockStructure.ItemStackMap.entrySet()) {
            if (entry.getValue().m_41619_()) continue;
            Direction rotation = this.multiBlockStructure.RotationMap.get(entry.getKey());
            BlockPos pos1 = switch (this.getFacing()) {
                case Direction.NORTH -> new BlockPos(entry.getKey().m_123341_(), entry.getKey().m_123342_(), entry.getKey().m_123343_());
                case Direction.EAST -> new BlockPos(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                case Direction.WEST -> new BlockPos(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                case Direction.SOUTH -> new BlockPos(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + this.getFacing());
            };
            ItemStack item = entry.getValue();
            if (item.m_41619_()) continue;
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos1.m_123341_(), 0.25 + (double)pos1.m_123342_(), (double)pos1.m_123343_());
            if (rotation != null) {
                block6 : switch (this.getFacing()) {
                    case NORTH: {
                        switch (rotation) {
                            case SOUTH: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                                break;
                            }
                            case NORTH: {
                                break;
                            }
                            case WEST: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                                break;
                            }
                            case EAST: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (rotation) {
                            case SOUTH: {
                                break;
                            }
                            case NORTH: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                                break;
                            }
                            case WEST: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                                break;
                            }
                            case EAST: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (rotation) {
                            case SOUTH: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                                break;
                            }
                            case NORTH: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                                break;
                            }
                            case WEST: {
                                break;
                            }
                            case EAST: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (rotation) {
                            case SOUTH: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                                break block6;
                            }
                            case NORTH: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                                break block6;
                            }
                            case WEST: {
                                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                                break block6;
                            }
                        }
                    }
                }
            }
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            ItemRenderer renderItem = Minecraft.m_91087_().m_91291_();
            BakedModel itemModel = this.multiBlockStructure.bakedModelMap.get(entry.getKey());
            if (itemModel == null) {
                itemModel = renderItem.m_174264_(item, tile.getWorld(), null, 0);
                this.multiBlockStructure.bakedModelMap.put(entry.getKey(), itemModel);
            }
            int i = this.f_58857_ != null ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_58857_, (BlockPos)this.m_58899_()) : 0xF000F0;
            renderItem.m_115143_(item, ItemTransforms.TransformType.FIXED, false, poseStack, (MultiBufferSource)((LevelRendererAccessor)event.getLevelRenderer()).getRenderBuffers().m_110104_(), i, OverlayTexture.f_118083_, itemModel);
            ((LevelRendererAccessor)event.getLevelRenderer()).getRenderBuffers().m_110104_().m_109911_();
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderUniqueMultiBlock(RenderLevelStageEvent event) {
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public void setFull(boolean full) {
        if (!full && !this.entityPlayerList.isEmpty()) {
            this.entityPlayerList.forEach(Player::m_6915_);
        }
        this.full = full;
        if (full) {
            this.rotateBlocks();
        }
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "full", full);
        }
    }

    @Override
    public MultiBlockStructure getMultiBlockStucture() {
        return this.multiBlockStructure;
    }

    @Override
    public boolean wasActivated() {
        return this.activate;
    }

    @Override
    public void setActivated(boolean active) {
        this.activate = active;
        new PacketUpdateFieldTile(this, "activate", this.activate);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("full")) {
            try {
                this.full = (Boolean)DecoderHandler.decode(is);
                if (this.full) {
                    this.updateAfterAssembly();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("activate")) {
            try {
                this.activate = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visible")) {
            try {
                this.visible = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && !this.activate) {
            this.setFull(false);
        }
    }

    @Override
    public void updateFull() {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.m_58899_(), this.m_58904_()));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public void loadBeforeFirstClientUpdate() {
        super.loadBeforeFirstClientUpdate();
        if (this.activate) {
            this.updateFull();
            if (this.full) {
                this.updateAfterAssembly();
            } else {
                this.activate = false;
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (this.activate) {
            this.updateFull();
            if (this.full) {
                this.updateAfterAssembly();
            } else {
                this.activate = false;
            }
        }
    }

    @Override
    public void updateFull(Player player) {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.m_58899_(), this.m_58904_(), player));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.full || !this.activate) {
            this.getCooldownTracker().setTick(1);
            if (!this.getMultiBlockStucture().isHasActivatedItem()) {
                this.updateFull(player);
                if (this.full) {
                    this.updateAfterAssembly();
                }
                return true;
            }
            if (this.getMultiBlockStucture().isActivateItem(player.m_21120_(hand))) {
                this.updateFull(player);
                if (!this.full) {
                    return false;
                }
                this.updateAfterAssembly();
            } else if (!this.getWorld().f_46443_) {
                IUCore.proxy.messagePlayer(player, Localization.translate("iu.activate_multiblock") + " " + this.getMultiBlockStucture().getActivateItem().m_41611_().getString());
            }
            return false;
        }
        this.usingBeforeGUI();
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.m_58904_().f_46443_) {
            this.render = BlockEntityMultiBlockBase.createFunction(this);
            GlobalRenderManager.addRender(this.getWorld(), this.pos, this.render);
        }
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.f_58857_.f_46443_) {
            return true;
        }
        this.getCooldownTracker().setTick(20);
        this.visible = !this.visible;
        new PacketUpdateFieldTile(this, "visible", this.visible);
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    @Override
    public void onUnloaded() {
        if (this.m_58904_().f_46443_) {
            GlobalRenderManager.removeRender(this.getWorld(), this.pos);
        }
        if (this.isFull() && this.multiBlockStructure != null) {
            List<BlockPos> blockPosList = this.multiBlockStructure.getPoses(this.getFacing(), this.m_58899_());
            for (BlockPos pos1 : blockPosList) {
                BlockEntity tileentity = this.m_58904_().m_7702_(pos1);
                if (!(tileentity instanceof BlockEntityMultiBlockElement)) continue;
                BlockEntityMultiBlockElement te = (BlockEntityMultiBlockElement)tileentity;
                te.setMainMultiElement(null);
            }
        }
        super.onUnloaded();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.activate = nbttagcompound.m_128471_("activate");
        this.visible = nbttagcompound.m_128471_("visible");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128379_("activate", this.activate);
        nbttagcompound.m_128379_("visible", this.visible);
        return nbttagcompound;
    }

    @Override
    public MainMultiBlock getMain() {
        return this;
    }

    @Override
    public void setMainMultiElement(MainMultiBlock main) {
    }
}

