/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.multimechanism.photonic;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.blockentity.base.EnumMultiMachine;
import com.denfop.blockentity.mechanism.multimechanism.IFarmer;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlocksPhotonicMachine;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityPhotonicFermer
extends BlockEntityMultiMachine
implements IFarmer {
    private final Inventory fertilizerSlot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

        @Override
        public boolean m_7013_(int index, ItemStack stack) {
            return stack.m_41720_() == IUItem.fertilizer.getItem();
        }

        @Override
        public EnumTypeSlot getTypeSlot() {
            return EnumTypeSlot.FERTILIZER;
        }
    };
    int col = 0;

    public BlockEntityPhotonicFermer(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.PHO_Fermer, BlocksPhotonicMachine.photonic_fermer, pos, state);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.cold.buffer.storage = 0.0;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.col = customPacketBuffer.readInt();
    }

    @Override
    public int getFertilizer() {
        return this.col;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        packetBuffer.writeInt(this.col);
        return packetBuffer;
    }

    @Override
    public Inventory getFertilizerSlot() {
        return this.fertilizerSlot;
    }

    @Override
    public int getSize(int size) {
        size = Math.min(super.getSize(size), this.fertilizerSlot.get(0).m_41613_() * 8 + this.col);
        return size;
    }

    @Override
    public boolean canoperate(int size) {
        return !this.fertilizerSlot.m_7983_() && this.fertilizerSlot.get(0).m_41613_() * 8 + this.col >= size;
    }

    @Override
    public void consume(int size) {
        int size1 = size;
        while (size1 > 0) {
            if (this.col == 0) {
                this.col += 16;
                this.fertilizerSlot.get(0).m_41774_(1);
            }
            if (size1 <= this.col) {
                this.col -= size1;
                size1 = 0;
                continue;
            }
            size1 -= this.col;
            this.col = 0;
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlocksPhotonicMachine.photonic_fermer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.pho_machine.getBlock(this.getTeBlock().getId());
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.PHO_Fermer;
    }
}

