/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.multimechanism.simple;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.blockentity.base.EnumMultiMachine;
import com.denfop.blocks.BlockRaws;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMoreMachine1Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.Localization;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityCombMacerator
extends BlockEntityMultiMachine {
    public static List<String> ores = new ArrayList<String>();
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public BlockEntityCombMacerator(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.COMB_MACERATOR.usagePerTick, EnumMultiMachine.COMB_MACERATOR.lenghtOperation, BlockMoreMachine1Entity.comb_macerator, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.15));
    }

    public static void addRecipe(String input, String output) {
        ResourceLocation input1 = new ResourceLocation("forge:" + output);
        TagKey tag = ItemTags.create((ResourceLocation)input1);
        Iterable holder = Registry.f_122827_.m_206058_(tag);
        Optional<Item> maybeItem = StreamSupport.stream(holder.spliterator(), false).map(Holder::m_203334_).findFirst();
        ItemStack stack = ItemStack.f_41583_;
        if (maybeItem.isPresent()) {
            stack = new ItemStack((ItemLike)maybeItem.get());
        }
        if (!stack.m_41619_()) {
            stack.m_41764_(3);
            IUCore.get_comb_crushed.add(stack);
            IInputHandler input2 = Recipes.inputFactory;
            Recipes.recipes.addRecipe("comb_macerator", new BaseMachineRecipe(new Input(input2.getInput("forge:" + input)), new RecipeOutput(null, stack)));
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockMoreMachine1Entity.comb_macerator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines_base1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        HashSet ores = new HashSet();
        Registry.f_122827_.m_203612_().forEach(tag -> {
            ResourceLocation tagId = ((TagKey)tag.getFirst()).f_203868_();
            String name = tagId.m_135815_();
            if (name.startsWith("crushed/") && !name.startsWith("purifiedcrushed/")) {
                Object name1 = name.substring("crushed".length());
                if (((String)name1).startsWith("/uranium")) {
                    return;
                }
                name1 = "ores" + (String)name1;
                String name2 = "raw_materials" + name.substring("crushed".length());
                if (this.isTagNotEmpty((String)name1) && this.isTagNotEmpty(name)) {
                    if (this.isTagNotEmpty(name2)) {
                        if (!ores.contains(name)) {
                            BlockEntityCombMacerator.addRecipe(name2, name);
                            ores.add(name);
                        }
                    } else if (!ores.contains(name)) {
                        BlockEntityCombMacerator.addRecipe((String)name1, name);
                        ores.add(name);
                    }
                }
            }
        });
        for (int i = 0; i < BlockRaws.Type.values().length; ++i) {
            BlockEntityCombMacerator.addmacerator("forge:storage_blocks/" + BlockRaws.Type.values()[i].getName(), "forge:crushed/" + BlockRaws.Type.values()[i].name(), 27);
        }
        BlockEntityCombMacerator.addmacerator("forge:storage_blocks/raw_iron", "forge:crushed/iron", 27);
        BlockEntityCombMacerator.addmacerator("forge:storage_blocks/raw_copper", "forge:crushed/copper", 27);
        BlockEntityCombMacerator.addmacerator("forge:storage_blocks/raw_gold", "forge:crushed/gold", 27);
    }

    public static void addmacerator(String input, String output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        ItemStack stack = input1.getInput(output).getInputs().get(0).m_41777_();
        stack.m_41764_(n);
        Recipes.recipes.addRecipe("comb_macerator", new BaseMachineRecipe(new Input(input1.getInput(input, 1)), new RecipeOutput(null, stack)));
    }

    private boolean isTagNotEmpty(String tagName) {
        return !Registry.f_122827_.m_203612_().filter(tag -> ((TagKey)tag.getFirst()).f_203868_().m_135815_().equals(tagName)).toList().isEmpty();
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.COMB_MACERATOR;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockCombMacerator.name");
    }

    public String getStartSoundFile() {
        return "Machines/MaceratorOp.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }
}

