/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.multimechanism.simple;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.blockentity.base.EnumMultiMachine;
import com.denfop.blockentity.mechanism.multimechanism.IFarmer;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMoreMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.Localization;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityFermer
extends BlockEntityMultiMachine
implements IFarmer {
    private final Inventory fertilizerSlot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

        @Override
        public boolean m_7013_(int index, ItemStack stack) {
            return stack.m_41720_() == IUItem.fertilizer.getItem();
        }

        @Override
        public EnumTypeSlot getTypeSlot() {
            return EnumTypeSlot.FERTILIZER;
        }
    };
    private final AirPollutionComponent pollutionAir;
    private final SoilPollutionComponent pollutionSoil;
    int col = 0;

    public BlockEntityFermer(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.Fermer.usagePerTick, EnumMultiMachine.Fermer.lenghtOperation, BlockMoreMachine3Entity.farmer, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.15));
    }

    public static void addrecipe(ItemStack input, Item output) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, new ItemStack((ItemLike)output))));
    }

    public static void addrecipe(ItemStack input, Item output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, new ItemStack((ItemLike)output, n))));
    }

    public static void addrecipe(Item input, ItemStack output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(new ItemStack((ItemLike)input))), new RecipeOutput(null, new ItemStack((ItemLike)output.m_41720_(), n))));
    }

    public static void addrecipe(Item input, Item output) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(new ItemStack((ItemLike)input))), new RecipeOutput(null, new ItemStack((ItemLike)output))));
    }

    public static void addrecipe(ItemStack input, ItemStack output) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, output)));
    }

    public static void addrecipe(ItemStack input, ItemStack output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        output = output.m_41777_();
        output.m_41764_(n);
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, output)));
    }

    public static void addrecipe(Item input, Item output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(new ItemStack((ItemLike)input))), new RecipeOutput(null, new ItemStack((ItemLike)output, n))));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.col = customPacketBuffer.readInt();
    }

    @Override
    public int getFertilizer() {
        return this.col;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        packetBuffer.writeInt(this.col);
        return packetBuffer;
    }

    @Override
    public Inventory getFertilizerSlot() {
        return this.fertilizerSlot;
    }

    @Override
    public int getSize(int size) {
        size = Math.min(super.getSize(size), this.fertilizerSlot.get(0).m_41613_() * 8 + this.col);
        return size;
    }

    @Override
    public boolean canoperate(int size) {
        return !this.fertilizerSlot.m_7983_() && this.fertilizerSlot.get(0).m_41613_() * 8 + this.col >= size;
    }

    @Override
    public void consume(int size) {
        int size1 = size;
        while (size1 > 0) {
            if (this.col == 0) {
                this.col += 16;
                this.fertilizerSlot.get(0).m_41774_(1);
            }
            if (size1 <= this.col) {
                this.col -= size1;
                size1 = 0;
                continue;
            }
            size1 -= this.col;
            this.col = 0;
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockMoreMachine3Entity.farmer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines_base3.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        BlockEntityFermer.addrecipe(Items.f_42404_, Items.f_42405_, 2);
        BlockEntityFermer.addrecipe(Items.f_42405_, Items.f_42404_, 1);
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)IUItem.rubberSapling.getItem()), new ItemStack((ItemLike)IUItem.rubWood.getItem(0)), 1);
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)IUItem.rubWood.getItem(0)), new ItemStack((ItemLike)IUItem.rawLatex.getItem(), 2), 2);
        BlockEntityFermer.addrecipe(IUItem.rawLatex.getItem(), new ItemStack((ItemLike)IUItem.rubberSapling.getItem()), 1);
        BlockEntityFermer.addrecipe(Items.f_42619_, Items.f_42619_, 2);
        BlockEntityFermer.addrecipe(Items.f_42620_, Items.f_42620_, 2);
        BlockEntityFermer.addrecipe(Blocks.f_50133_.m_5456_(), Items.f_42577_, 1);
        BlockEntityFermer.addrecipe(Items.f_42577_, Blocks.f_50133_.m_5456_(), 2);
        BlockEntityFermer.addrecipe(Items.f_42578_, Items.f_42028_, 2);
        BlockEntityFermer.addrecipe(Items.f_42028_, Items.f_42578_, 1);
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50746_, 1), new ItemStack((ItemLike)Blocks.f_49999_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50748_, 1), new ItemStack((ItemLike)Blocks.f_50001_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50750_, 1), new ItemStack((ItemLike)Blocks.f_50003_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50749_, 1), new ItemStack((ItemLike)Blocks.f_50002_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50751_, 1), new ItemStack((ItemLike)Blocks.f_50004_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50747_, 1), new ItemStack((ItemLike)Blocks.f_50000_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_49999_, 1), new ItemStack((ItemLike)Blocks.f_50746_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50001_, 1), new ItemStack((ItemLike)Blocks.f_50748_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50003_, 1), new ItemStack((ItemLike)Blocks.f_50750_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50002_, 1), new ItemStack((ItemLike)Blocks.f_50749_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50004_, 1), new ItemStack((ItemLike)Blocks.f_50751_, 2));
        BlockEntityFermer.addrecipe(new ItemStack((ItemLike)Blocks.f_50000_, 1), new ItemStack((ItemLike)Blocks.f_50747_, 2));
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.Fermer;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockFermer.name");
    }

    public String getStartSoundFile() {
        return "Machines/Fermer.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }
}

