/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.quarry;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class QuarryItem {
    private final ItemStack stack;
    private TagKey<Item> oreDict;

    public QuarryItem(ItemStack stack) {
        this.stack = stack;
        List list = stack.m_204131_().toList();
        try {
            this.oreDict = (TagKey)list.get(0);
        }
        catch (Exception e) {
            this.oreDict = new TagKey(Registry.f_122904_, new ResourceLocation("", "unknown"));
        }
    }

    public QuarryItem(ItemStack stack, TagKey<Item> oreDict) {
        this.stack = stack;
        this.oreDict = oreDict;
    }

    public QuarryItem(String oreDict) {
        this.oreDict = new TagKey(Registry.f_122904_, new ResourceLocation(oreDict));
        this.stack = (ItemStack)new Ingredient.TagValue(this.oreDict).m_6223_().stream().toList().get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuarryItem that = (QuarryItem)o;
        return this.stack.m_150930_(that.getStack().m_41720_());
    }

    public int hashCode() {
        return Objects.hash(this.stack, this.oreDict);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public TagKey<Item> getOreDict() {
        return this.oreDict;
    }

    public boolean isGem() {
        return this.getOreDict().f_203868_().m_135815_().startsWith("gem");
    }

    public boolean isShard() {
        return this.getOreDict().f_203868_().m_135815_().startsWith("shard");
    }
}

