/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.solardestiller;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.BlockEntityUpgrade;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.FluidName;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSolarDestiller;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryTank;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSolarDestiller;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BlockEntityBaseSolarDestiller
extends BlockEntityInventory
implements BlockEntityUpgrade,
IType {
    public final FluidTank inputTank;
    public final FluidTank outputTank;
    public final InventoryOutput wateroutputSlot;
    public final InventoryOutput destiwateroutputSlott;
    public final InventoryFluidByList waterinputSlot;
    public final InventoryTank destiwaterinputSlot;
    public final InventoryUpgrade upgradeSlot;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final EnumTypeStyle style;
    private int tickrate;
    private boolean skyLight;
    private boolean hasSky;

    public BlockEntityBaseSolarDestiller(EnumTypeStyle style, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.style = style;
        this.inputTank = this.fluids.addTankInsert("inputTank", 10000, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.f_76193_}));
        this.outputTank = this.fluids.addTankExtract("outputTank", 10000, Fluids.fluidPredicate((Fluid)FluidName.fluiddistilled_water.getInstance().get()));
        this.waterinputSlot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.INPUT, new Fluid[]{net.minecraft.world.level.material.Fluids.f_76193_});
        this.destiwaterinputSlot = new InventoryTank(this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, (IFluidTank)this.outputTank);
        this.wateroutputSlot = new InventoryOutput(this, 1);
        this.destiwateroutputSlott = new InventoryOutput(this, 1);
        this.upgradeSlot = new InventoryUpgrade(this, 3);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.tickrate = this.getTickRate();
        this.hasSky = this.m_58904_().m_46472_() != Level.f_46429_;
        this.updateVisibility();
    }

    public void updateVisibility() {
        this.skyLight = this.f_58857_.m_45527_(this.pos.m_7494_()) && this.f_58857_.m_8055_(this.pos.m_7494_()).m_60780_((BlockGetter)this.f_58857_, this.pos.m_7494_()) == MaterialColor.f_76398_ && this.hasSky && this.f_58857_.m_46461_();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.skyLight = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.skyLight);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.waterinputSlot.processIntoTank((IFluidTank)this.inputTank, this.wateroutputSlot);
        if (this.getWorld().m_46467_() % 40L == 0L) {
            this.updateVisibility();
        }
        this.destiwaterinputSlot.processFromTank((IFluidTank)this.outputTank, this.destiwateroutputSlott);
        if (!this.skyLight) {
            return;
        }
        if (this.getWorld().m_46467_() % (long)this.tickrate == 0L && this.canWork()) {
            this.inputTank.drain(this.getAmountWater(), IFluidHandler.FluidAction.EXECUTE);
            this.outputTank.fill(new FluidStack((Fluid)FluidName.fluiddistilled_water.getInstance().get(), 1), IFluidHandler.FluidAction.EXECUTE);
        }
        this.upgradeSlot.tickNoMark();
    }

    public ContainerMenuSolarDestiller getGuiContainer(Player player) {
        return new ContainerMenuSolarDestiller(player, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player player, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenSolarDestiller((ContainerMenuSolarDestiller)isAdmin);
    }

    public int getAmountWater() {
        switch (this.style) {
            case DEFAULT: {
                return 4;
            }
            case ADVANCED: {
                return 4;
            }
            case IMPROVED: {
                return 3;
            }
            case PERFECT: {
                return 2;
            }
            case PHOTONIC: {
                return 1;
            }
        }
        return 4;
    }

    public int getTickRate() {
        Holder biome = this.f_58857_.m_204166_(this.pos);
        if (biome.m_203656_(Tags.Biomes.IS_HOT)) {
            switch (this.style) {
                case DEFAULT: {
                    return 36;
                }
                case ADVANCED: {
                    return 20;
                }
                case IMPROVED: {
                    return 11;
                }
                case PERFECT: {
                    return 6;
                }
                case PHOTONIC: {
                    return 4;
                }
            }
        } else {
            boolean isCold = biome.m_203656_(Tags.Biomes.IS_COLD);
            switch (this.style) {
                case DEFAULT: {
                    return isCold ? 144 : 72;
                }
                case ADVANCED: {
                    return isCold ? 80 : 40;
                }
                case IMPROVED: {
                    return isCold ? 44 : 22;
                }
                case PERFECT: {
                    return isCold ? 24 : 12;
                }
                case PHOTONIC: {
                    return isCold ? 16 : 8;
                }
            }
        }
        return 0;
    }

    public int gaugeLiquidScaled(int i, int tank) {
        switch (tank) {
            case 0: {
                if (this.inputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.inputTank.getFluidAmount() * i / this.inputTank.getCapacity();
            }
            case 1: {
                if (this.outputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.outputTank.getFluidAmount() * i / this.outputTank.getCapacity();
            }
        }
        return 0;
    }

    public boolean canWork() {
        return this.inputTank.getFluidAmount() >= this.getAmountWater() && this.outputTank.getFluidAmount() < this.outputTank.getCapacity() && this.skyLight;
    }

    @Override
    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.FluidInput, EnumBlockEntityUpgrade.FluidExtract);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.style;
    }
}

