/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamDryer;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamDryer;
import com.denfop.sound.EnumSound;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntitySteamDryer
extends BlockEntityElectricMachine
implements IHasRecipe {
    public final FluidHandlerRecipe fluid_handler;
    public final Fluids.InternalFluidTank fluidTank1;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final Fluids.InternalFluidTank fluidTank;
    public final ComponentSteamEnergy steam;
    public final PressureComponent pressure;
    private final Fluids fluids = this.addComponent(new Fluids(this));
    public double energyConsume = 2.0;
    public int operationLength = 100;
    public int operationsPerTick = 1;
    protected short progress = 0;
    protected double guiProgress;

    public BlockEntitySteamDryer(BlockPos pos, BlockState state) {
        super(0.0, 1, 1, BlockBaseMachine3Entity.steamdryer, pos, state);
        this.defaultEnergyConsume = 2.0;
        this.defaultOperationLength = 100;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        this.fluidTank1 = this.fluids.addTankInsert("fluidTank1", 12000);
        this.fluidTank = this.fluids.addTank("fluidTank2", 4000, Inventory.TypeItemSlot.NONE, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.pressure = this.addComponent(PressureComponent.asBasicSink(this, 2.0));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank);
        this.fluid_handler = new FluidHandlerRecipe("dryer", this.fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        Recipes.recipes.getRecipeFluid().addInitRecipes(this);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void init() {
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.steam.getSoundEvent();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.fluid_handler.load();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && this.fluidTank1.getFluidAmount() >= 1) {
            this.fluid_handler.getOutput();
        } else if (this.fluid_handler.output() != null && !this.fluid_handler.checkFluids()) {
            this.fluid_handler.setOutput(null);
        }
        if (this.fluid_handler.output() != null && this.pressure.getEnergy() >= 2.0 && this.outputSlot.canAdd(this.fluid_handler.output().getOutput().items) && this.fluid_handler.canOperate() && this.steam.canUseEnergy(this.energyConsume)) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.steam.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.fluid_handler.output() == null) {
                this.progress = 0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
    }

    public void setOverclockRates() {
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate() {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            this.operateOnce();
            this.fluid_handler.checkOutput();
            if (this.fluid_handler.output() == null) break;
        }
    }

    public void operateOnce() {
        this.fluid_handler.consume();
        this.outputSlot.add(this.fluid_handler.output().getOutput().items);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.steamdryer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerMenuSteamDryer getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSteamDryer(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamDryer((ContainerMenuSteamDryer)menu);
    }

    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.Processing, EnumBlockEntityUpgrade.Transformer, EnumBlockEntityUpgrade.EnergyStorage, EnumBlockEntityUpgrade.FluidInput, EnumBlockEntityUpgrade.ItemExtract);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }
}

