/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.ComponentSteamProcess;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.PressureComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamHandlerHeavyOre;
import com.denfop.inventory.Inventory;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamHandlerHeavyOre;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntitySteamHandlerHeavyOre
extends BlockEntityElectricMachine
implements IUpdateTick,
IType {
    public final InventoryOutput outputSlot;
    public final ComponentSteamProcess componentProcess;
    public final ComponentProgress componentProgress;
    public final Fluids.InternalFluidTank fluidTank;
    public final PressureComponent pressure;
    public final ComponentSteamEnergy steam;
    public final HeatComponent heat;
    private final EnumTypeStyle enumTypeSlot = EnumTypeStyle.DEFAULT;
    private final double coef;
    private final Fluids fluids;
    public InventoryRecipes inputSlotA;
    public MachineRecipe output;
    private int[] col;
    private boolean work = false;

    public BlockEntitySteamHandlerHeavyOre(BlockPos pos, BlockState state) {
        super(0.0, 1, 1, BlockBaseMachine3Entity.steam_handler_ore, pos, state);
        this.outputSlot = new InventoryOutput(this, 3 + 2 * this.enumTypeSlot.ordinal());
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "handlerho", (IUpdateTick)this);
        this.col = new int[0];
        this.coef = this.getCoef();
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, 300));
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank2", 4000, Inventory.TypeItemSlot.NONE, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.heat = this.addComponent(HeatComponent.asBasicSink(this, 3000.0));
        this.pressure = this.addComponent(PressureComponent.asBasicSink(this, 3.0));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank);
        this.componentProcess = this.addComponent(new ComponentSteamProcess(this, (int)(300.0 / this.getSpeed()), 1.0, 3){

            @Override
            public void operateWithMax(MachineRecipe output) {
                if (output.getRecipe() == null) {
                    return;
                }
                for (int i = 0; i < 1; ++i) {
                    this.operate(output);
                }
            }

            @Override
            public void operateOnce(List<ItemStack> processResult) {
                for (int i = 0; i < BlockEntitySteamHandlerHeavyOre.this.col.length; ++i) {
                    RandomSource rand = ((BlockEntitySteamHandlerHeavyOre)BlockEntitySteamHandlerHeavyOre.this).f_58857_.f_46441_;
                    if (100 - BlockEntitySteamHandlerHeavyOre.this.col[i] > rand.m_188503_(100)) continue;
                    this.outputSlot.add(processResult.get(i));
                }
                this.invSlotRecipes.consume();
            }
        });
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.steam_handler_ore;
    }

    protected double getCoef() {
        switch (this.enumTypeSlot) {
            case ADVANCED: {
                return 1.1;
            }
            case PERFECT: {
                return 1.3;
            }
            case IMPROVED: {
                return 1.2;
            }
        }
        return 1.0;
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.enumTypeSlot;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.heatmachine.info"));
        }
        tooltip.add(Localization.translate("iu.steam_separator"));
        super.addInformation(stack, tooltip);
    }

    public Set<EnumBlockEntityUpgrade> getUpgradableProperties() {
        return EnumSet.of(EnumBlockEntityUpgrade.Processing, EnumBlockEntityUpgrade.Transformer, EnumBlockEntityUpgrade.EnergyStorage, EnumBlockEntityUpgrade.ItemExtract, EnumBlockEntityUpgrade.ItemInput);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.work) {
            if (this.pos.m_7495_().m_123331_((Vec3i)neighborPos) == 0.0) {
                FluidState blockState = this.f_58857_.m_6425_(this.pos.m_7495_());
                this.work = blockState.m_76152_() != net.minecraft.world.level.material.Fluids.f_76191_ ? blockState.m_76152_().m_6212_(Fluids.LAVA) : false;
            }
        } else if (this.pos.m_7495_().m_123331_((Vec3i)neighborPos) == 0.0) {
            FluidState blockState = this.f_58857_.m_6425_(this.pos.m_7495_());
            this.work = blockState.m_76152_() != net.minecraft.world.level.material.Fluids.f_76191_ ? blockState.m_76152_().m_6212_(Fluids.LAVA) : false;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            FluidState blockState = this.f_58857_.m_6425_(this.pos.m_7495_());
            this.work = blockState.m_76152_() != net.minecraft.world.level.material.Fluids.f_76191_ ? blockState.m_76152_().m_6212_(Fluids.LAVA) : false;
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    public ContainerMenuSteamHandlerHeavyOre getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSteamHandlerHeavyOre(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamHandlerHeavyOre((ContainerMenuSteamHandlerHeavyOre)menu);
    }

    public void operateOnce(List<ItemStack> processResult) {
        for (int i = 0; i < this.col.length; ++i) {
            RandomSource rand = this.f_58857_.f_46441_;
            if (100 - this.col[i] > rand.m_188503_(100)) continue;
            this.outputSlot.add(processResult.get(i));
        }
        this.inputSlotA.consume();
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.getWorld().m_46467_() % 2L == 0L) {
            this.heat.addEnergy(1.0);
        }
        if (this.getWorld().m_46467_() % 20L == 0L) {
            this.heat.useEnergy(1.0);
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.handlerho.getSoundEvent();
    }

    @Override
    public void onUpdate() {
    }

    private double getSpeed() {
        switch (this.enumTypeSlot) {
            case ADVANCED: {
                return 1.3;
            }
            case IMPROVED: {
                return 1.5;
            }
            case PERFECT: {
                return 2.0;
            }
        }
        return 1.0;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        if (output == null) {
            this.col = new int[0];
        } else {
            this.col = new int[output.getRecipe().output.items.size()];
            for (int i = 0; i < this.col.length; ++i) {
                this.col[i] = (int)((double)output.getRecipe().output.metadata.m_128451_("input" + i) * this.coef);
                this.col[i] = Math.max(0, Math.min(this.col[i], 95) - 5);
            }
        }
    }
}

