/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.heat.pump;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.reactors.heat.IPump;
import com.denfop.blocks.ISubEnum;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuHeatPump;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemCraftingElements;
import com.denfop.screen.ScreenHeatPump;
import com.denfop.screen.ScreenIndustrialUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityBasePump
extends BlockEntityMultiBlockElement
implements IPump {
    private final int levelBlock;
    private final Inventory slot;
    private int power;
    private int energy;

    public BlockEntityBasePump(int levelBlock, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.levelBlock = levelBlock;
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public int getStackSizeLimit() {
                return 1;
            }

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                if (!(stack.m_41720_() instanceof ItemCraftingElements)) {
                    return false;
                }
                int itemDamage = ((ISubEnum)((ItemCraftingElements)stack.m_41720_()).getElement()).getId();
                switch (itemDamage) {
                    case 276: {
                        return ((BlockEntityBasePump)this.base).getBlockLevel() >= 0;
                    }
                    case 20: {
                        return ((BlockEntityBasePump)this.base).getBlockLevel() >= 1;
                    }
                    case 96: {
                        return ((BlockEntityBasePump)this.base).getBlockLevel() >= 2;
                    }
                    case 120: {
                        return ((BlockEntityBasePump)this.base).getBlockLevel() >= 3;
                    }
                }
                return false;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (content.m_41619_()) {
                    ((BlockEntityBasePump)this.base).setEnergy(0);
                    ((BlockEntityBasePump)this.base).setPower(0);
                } else {
                    int itemDamage = ((ISubEnum)((ItemCraftingElements)content.m_41720_()).getElement()).getId();
                    switch (itemDamage) {
                        case 276: {
                            ((BlockEntityBasePump)this.base).setEnergy(5);
                            ((BlockEntityBasePump)this.base).setPower(1);
                            break;
                        }
                        case 20: {
                            ((BlockEntityBasePump)this.base).setEnergy(10);
                            ((BlockEntityBasePump)this.base).setPower(2);
                            break;
                        }
                        case 96: {
                            ((BlockEntityBasePump)this.base).setEnergy(20);
                            ((BlockEntityBasePump)this.base).setPower(3);
                            break;
                        }
                        case 120: {
                            ((BlockEntityBasePump)this.base).setEnergy(40);
                            ((BlockEntityBasePump)this.base).setPower(4);
                        }
                    }
                }
                return content;
            }
        };
    }

    public ContainerMenuHeatPump getGuiContainer(Player var1) {
        return new ContainerMenuHeatPump(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenHeatPump((ContainerMenuHeatPump)menu);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            if (this.getSlot().get(0).m_41619_()) {
                this.setEnergy(0);
                this.setPower(0);
            } else {
                int itemDamage = ((ISubEnum)((ItemCraftingElements)this.getSlot().get(0).m_41720_()).getElement()).getId();
                switch (itemDamage) {
                    case 276: {
                        this.setEnergy(5);
                        this.setPower(1);
                        break;
                    }
                    case 20: {
                        this.setEnergy(10);
                        this.setPower(2);
                        break;
                    }
                    case 96: {
                        this.setEnergy(20);
                        this.setPower(3);
                        break;
                    }
                    case 120: {
                        this.setEnergy(40);
                        this.setPower(4);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public int getBlockLevel() {
        return this.levelBlock;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public Inventory getSlot() {
        return this.slot;
    }
}

