/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.tiles;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.energy.networking.ConductorInfo;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.otherenergies.common.InfoCable;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.common.event.EnergyEvent;
import com.denfop.api.otherenergies.common.event.EnumTypeEvent;
import com.denfop.api.otherenergies.common.interfaces.Acceptor;
import com.denfop.api.otherenergies.common.interfaces.Conductor;
import com.denfop.api.otherenergies.common.interfaces.Emitter;
import com.denfop.api.otherenergies.common.interfaces.Tile;
import com.denfop.blockentity.transport.tiles.BlockEntityMultiCable;
import com.denfop.blockentity.transport.types.QEType;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockEntityQCable
extends BlockEntityMultiCable
implements Conductor {
    public boolean addedToEnergyNet;
    protected QEType cableType;
    Map<Direction, Tile> energyConductorMap = new HashMap<Direction, Tile>();
    List<InfoTile<Tile>> validReceivers = new LinkedList<InfoTile<Tile>>();
    int hashCodeSource;
    boolean updateConnect = false;
    Map<EnergyType, ConductorInfo> conductorInfoMap = new HashMap<EnergyType, ConductorInfo>();
    private boolean needUpdate;
    private InfoCable cable;
    private long id;

    public BlockEntityQCable(QEType cableType, MultiBlockEntity tileBlock, BlockPos pos, BlockState state) {
        super(cableType, tileBlock, pos, state);
        this.cableType = cableType;
    }

    @Override
    public InfoCable getCable(EnergyType type) {
        return this.cable;
    }

    @Override
    public void setCable(EnergyType type, InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public ConductorInfo getInfo(EnergyType energyType) {
        if (this.conductorInfoMap.isEmpty()) {
            if (this.getEnergies() == null || this.getEnergies().isEmpty()) {
                this.conductorInfoMap.put(this.getEnergyType(), new ConductorInfo(this.pos, this, this.getEnergyType()));
            } else {
                for (EnergyType e : this.getEnergies()) {
                    this.conductorInfoMap.put(e, new ConductorInfo(this.pos, this, e));
                }
            }
        }
        return this.conductorInfoMap.get((Object)energyType);
    }

    public BlockPos m_58899_() {
        return this.pos;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.cableType = QEType.values[nbt.m_128445_("cableType") & 0xFF];
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128344_("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_ && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_ && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public Map<Direction, Tile> getTiles(EnergyType type) {
        return this.energyConductorMap;
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.getWorld().f_46443_) {
            this.updateConnectivity();
        }
    }

    @Override
    public void updateConnectivity() {
        byte newConnectivity = 0;
        Direction[] var4 = Direction.values();
        Map<Direction, Tile> map = this.energyConductorMap;
        for (Direction dir : var4) {
            newConnectivity = (byte)(newConnectivity << 1);
            Tile tile = map.get(dir);
            if (dir == null || this.getBlackList().contains(dir) || (!(tile instanceof Acceptor) || !((Acceptor)tile).acceptsFrom(this, dir.m_122424_())) && (!(tile instanceof Emitter) || !((Emitter)tile).emitsTo(this, dir.m_122424_()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return false;
    }

    @Override
    public boolean acceptsFrom(Emitter emitter, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsTo(Acceptor receiver, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductorBreakdownEnergy(EnergyType type) {
        return this.cableType.capacity + 1.0;
    }

    public Map<Direction, Tile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<Tile>> getValidReceivers(EnergyType type) {
        return this.validReceivers;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(EnergyType type, Tile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<Tile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<Tile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(EnergyType type, Tile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            if (!this.energyConductorMap.containsKey(facing1)) {
                this.energyConductorMap.put(facing1, tile);
                this.validReceivers.add(new InfoTile<Tile>(tile, facing1.m_122424_()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.QUANTUM;
    }

    @Override
    public boolean hasEnergies() {
        return false;
    }

    @Override
    public List<EnergyType> getEnergies() {
        return null;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = QEType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BlockEntity getTile() {
        return this;
    }
}

