/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.types;

import com.denfop.blockentity.transport.types.ICableItem;
import com.denfop.blocks.ISubEnum;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum CoolType implements ISubEnum,
ICableItem
{
    cool(0, 0, 0.25f, 0.02, 4.0),
    cool1(0, 0, 0.25f, 0.02, 8.0),
    cool2(0, 0, 0.25f, 0.2, 16.0),
    cool3(0, 0, 0.25f, 0.2, 32.0),
    cool4(0, 0, 0.25f, 0.2, 64.0);

    public static final CoolType[] values;
    private static final Map<String, CoolType> nameMap;
    public final int maxInsulation;
    public final int minColoredInsulation;
    public final float thickness;
    public final double loss;
    public final double capacity;
    private final ResourceLocation texture;

    private CoolType(int maxInsulation, int minColoredInsulation, float thickness, double loss, double capacity) {
        this.maxInsulation = maxInsulation;
        this.minColoredInsulation = minColoredInsulation;
        this.thickness = thickness;
        this.loss = loss;
        this.capacity = capacity;
        this.texture = new ResourceLocation("industrialupgrade", "blocks/wiring/" + this.getMainPath() + "/" + this.getNameCable());
    }

    public static CoolType get(String name) {
        return nameMap.get(name);
    }

    @Override
    public String getName() {
        return this.name() + "_pipes";
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    @Override
    public String getNameCable() {
        return this.name() + "_pipes";
    }

    @Override
    public String getMainPath() {
        return "cool";
    }

    @Override
    public ResourceLocation getRecourse() {
        return this.texture;
    }

    static {
        values = CoolType.values();
        nameMap = new HashMap<String, CoolType>();
        for (CoolType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

