/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.state;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blocks.state.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TypeProperty
extends Property<State> {
    public final String resourceLocationName;
    private final ConcurrentHashMap<MultiBlockEntity, StatesBlocks> mapStates;
    public List<State> allowedValues;
    List<StatesBlocks> locationBlocks;

    public TypeProperty(ResourceLocation identifier, MultiBlockEntity teBlock) {
        super("type", State.class);
        this.resourceLocationName = identifier.toString();
        this.mapStates = new ConcurrentHashMap();
        this.locationBlocks = new LinkedList<StatesBlocks>();
        String stateName = teBlock.hasActive() ? "active" : "";
        String[] multiModels = teBlock.getMultiModels(teBlock);
        StatesBlocks state = new StatesBlocks(teBlock, stateName, multiModels);
        this.locationBlocks.add(state);
        this.mapStates.put(teBlock, state);
        this.allowedValues = new LinkedList<State>();
        for (StatesBlocks teBlockPair : this.locationBlocks) {
            this.allowedValues.addAll(teBlockPair.statesBlocks);
        }
        if (this.allowedValues.size() == 1) {
            this.allowedValues.add(new State(teBlock, "invalid"));
        }
        this.allowedValues = new ArrayList<State>(this.allowedValues);
        this.locationBlocks = new ArrayList<StatesBlocks>(this.locationBlocks);
    }

    public List<StatesBlocks> getAllStates() {
        return this.locationBlocks;
    }

    public State getState(MultiBlockEntity teBlock) {
        return this.getState(teBlock, "");
    }

    public State getState(MultiBlockEntity teBlock, String active) {
        StatesBlocks state = this.mapStates.get(teBlock);
        return state == null ? null : state.getState(active);
    }

    public String m_61708_() {
        return "type";
    }

    @NotNull
    public Collection<State> m_6908_() {
        return this.allowedValues;
    }

    @NotNull
    public Class<State> m_61709_() {
        return State.class;
    }

    public Optional<State> m_6215_(String value) {
        for (State block : this.allowedValues) {
            if (!this.getName(block).equals(value)) continue;
            return Optional.of(block);
        }
        return Optional.empty();
    }

    public String getName(State value) {
        return !value.state.isEmpty() ? value.teBlock.getName() + "_" + value.state : value.teBlock.getName();
    }

    public String toString() {
        return "TypeProperty{For " + this.resourceLocationName + "}";
    }

    public static class StatesBlocks {
        public final boolean hasActive;
        public List<State> statesBlocks = new ArrayList<State>();

        public StatesBlocks(MultiBlockEntity block, String state, String[] multiModels) {
            this.statesBlocks.add(new State(block, ""));
            if (state.equals("active")) {
                this.statesBlocks.add(new State(block, state));
                this.hasActive = true;
            } else {
                this.hasActive = false;
            }
            if (multiModels != null) {
                for (String multiModel : multiModels) {
                    this.statesBlocks.add(new State(block, multiModel));
                }
            }
        }

        public MultiBlockEntity getBlock() {
            return this.statesBlocks.get((int)0).teBlock;
        }

        public State getState(String stateName) {
            for (State state : this.statesBlocks) {
                if (!state.state.equals(stateName)) continue;
                return state;
            }
            return this.statesBlocks.get(0);
        }

        public boolean hasActive() {
            return this.hasActive;
        }

        public boolean hasItem() {
            return this.getBlock().hasItem();
        }

        public String getName() {
            return this.getBlock().getName();
        }
    }
}

