/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketAbstractComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;

public abstract class AbstractComponent {
    protected BlockEntityBase parent;

    public AbstractComponent(BlockEntityBase parent) {
        this.parent = parent;
    }

    public BlockEntityBase getParent() {
        return this.parent;
    }

    public void setParent(BlockEntityBase parent) {
        this.parent = parent;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isServer() {
        return false;
    }

    public boolean canEntityDestroy(Entity entity) {
        return true;
    }

    public boolean wrenchCanRemove(Player player) {
        return true;
    }

    public void ActionPurifier() {
    }

    public boolean onSneakingActivated(Player player, InteractionHand hand) {
        return false;
    }

    public boolean canUpgradeBlock() {
        return false;
    }

    public void markDirty() {
    }

    public boolean needWriteNBTToDrops() {
        return false;
    }

    public CompoundTag writeNBTToDrops(CompoundTag tagCompound) {
        return tagCompound;
    }

    public void workPurifier() {
        if (this.getPurifierJob() == TypePurifierJob.Actions) {
            this.ActionPurifier();
        } else {
            this.actionGetDrop();
        }
    }

    public void actionGetDrop() {
        if (!this.getParent().m_58904_().f_46443_) {
            ItemStack itemstack = this.getItemStackUpgrade();
            if (itemstack.m_41619_()) {
                return;
            }
            ItemEntity item = new ItemEntity(EntityType.f_20461_, this.getParent().m_58904_());
            item.m_32045_(itemstack);
            item.m_6034_((double)this.getParent().m_58899_().m_123341_(), (double)this.getParent().m_58899_().m_123342_(), (double)this.getParent().m_58899_().m_123343_());
            item.m_32010_(0);
            this.getParent().m_58904_().m_7967_((Entity)item);
        }
    }

    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.None;
    }

    public boolean canUsePurifier(Player player) {
        return this.getPurifierJob() != TypePurifierJob.None;
    }

    public ItemStack getItemStackUpgrade() {
        return ItemStack.f_41583_;
    }

    public void updateEntityServer() {
    }

    public List<ItemStack> getDrops() {
        return new ArrayList<ItemStack>();
    }

    public void updateEntityClient() {
    }

    public boolean onBlockActivated(Player player, InteractionHand hand) {
        return false;
    }

    protected void setNetworkUpdate(ServerPlayer player, CustomPacketBuffer data) {
        new PacketAbstractComponent(this.parent, this.toString(), player, data);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void readFromNbt(CompoundTag nbt) {
    }

    public CompoundTag writeToNbt() {
        return new CompoundTag();
    }

    public void onLoaded() {
    }

    public void onUnloaded() {
    }

    public void onNeighborChange(BlockState srcBlock, BlockPos srcPos) {
    }

    public void onContainerUpdate(ServerPlayer player) {
    }

    public CustomPacketBuffer updateComponent() {
        return new CustomPacketBuffer();
    }

    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
    }

    public Collection<? extends Capability<?>> getProvidedCapabilities(Direction side) {
        return Collections.emptySet();
    }

    public <T> T getCapability(Capability<T> cap, Direction side) {
        return null;
    }

    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
    }

    public void blockBreak() {
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
    }
}

