/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.api.otherenergies.cool.ICoolSink;
import com.denfop.api.otherenergies.cool.ICoolTile;
import com.denfop.api.otherenergies.cool.event.CoolTileLoadEvent;
import com.denfop.api.otherenergies.cool.event.CoolTileUnloadEvent;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.TypePurifierJob;
import com.denfop.componets.cold.EnergyNetDelegate;
import com.denfop.componets.cold.EnergyNetDelegateSink;
import com.denfop.componets.cold.EnergyNetDelegateSource;
import com.denfop.items.modules.ItemCoolingUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CoolComponent
extends AbstractComponent {
    public final Level world;
    public final BufferEnergy buffer;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean upgrade = false;
    public int meta = 0;
    private double coef;
    public static boolean cooling = true;

    public CoolComponent(BlockEntityInventory parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public CoolComponent(BlockEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public CoolComponent(BlockEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.world = parent.m_58904_();
        this.buffer = new BufferEnergy(0.0, capacity, sinkTier, sourceTier);
        this.coef = 1.0;
    }

    public static CoolComponent asBasicSink(BlockEntityInventory parent, double capacity) {
        return CoolComponent.asBasicSink(parent, capacity, 1);
    }

    public static CoolComponent asBasicSink(BlockEntityInventory parent, double capacity, int tier) {
        return new CoolComponent(parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static CoolComponent asBasicSource(BlockEntityInventory parent, double capacity) {
        return CoolComponent.asBasicSource(parent, capacity, 1);
    }

    public static CoolComponent asBasicSource(BlockEntityInventory parent, double capacity, int tier) {
        return new CoolComponent(parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        this.buffer.storage = nbt.m_128459_("storage");
        this.upgrade = nbt.m_128471_("upgrade");
        this.meta = nbt.m_128451_("meta");
        this.buffer.allow = nbt.m_128471_("allow");
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag ret = new CompoundTag();
        ret.m_128347_("storage", this.buffer.storage);
        ret.m_128379_("upgrade", this.upgrade);
        ret.m_128405_("meta", this.meta);
        ret.m_128379_("allow", this.buffer.allow);
        return ret;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.buffer.storage > this.buffer.capacity) {
            this.buffer.storage = this.buffer.capacity;
        }
        if (!this.parent.m_58904_().f_46443_) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this.delegate, this.parent.m_58904_()));
            }
            this.loaded = true;
            Level world = this.parent.m_58904_();
            BlockPos pos = this.parent.m_58899_();
            Biome biome = (Biome)world.m_204166_(pos).m_203334_();
            this.coef = biome.m_198904_(pos) ? 0.5 : (biome.m_198904_(pos) ? 1.5 : 1.0);
        }
    }

    public void createDelegate() {
        if (this.delegate == null) {
            assert (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty());
            this.delegate = this.sinkDirections.isEmpty() ? new EnergyNetDelegateSource(this) : new EnergyNetDelegateSink(this);
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this.delegate, this.parent.m_58904_()));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        BlockEntityBase blockEntityBase;
        if (!player.m_9236_().m_5776_() && player != null && (blockEntityBase = this.getParent()) instanceof BlockEntityMultiMachine) {
            BlockEntityMultiMachine multiMachine = (BlockEntityMultiMachine)blockEntityBase;
            if (player.m_21120_(hand).m_41720_() instanceof ItemCoolingUpgrade) {
                ItemCoolingUpgrade coolingUpgrade = (ItemCoolingUpgrade)player.m_21120_(hand).m_41720_();
                if (multiMachine.multi_process.getSizeWorkingSlot() <= coolingUpgrade.getTypeUpgrade(player.m_21120_(hand)).getLevel() && !this.upgrade) {
                    this.upgrade = true;
                    this.meta = ((ItemCoolingUpgrade.Types)coolingUpgrade.getElement()).getId();
                    player.m_21120_(hand).m_41774_(1);
                    return true;
                }
            }
        }
        return super.onBlockActivated(player, hand);
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.buffer.capacity);
        buffer.writeDouble(this.buffer.storage);
        buffer.writeInt(this.meta);
        buffer.writeBoolean(this.upgrade);
        buffer.writeBoolean(this.buffer.allow);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.buffer.capacity = is.readDouble();
        this.buffer.storage = is.readDouble();
        this.meta = is.readInt();
        this.upgrade = is.readBoolean();
        this.buffer.allow = is.readBoolean();
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packet = super.updateComponent();
        packet.writeDouble(this.buffer.capacity);
        packet.writeDouble(this.buffer.storage);
        packet.writeInt(this.meta);
        packet.writeBoolean(this.upgrade);
        packet.writeBoolean(this.buffer.allow);
        return packet;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public double getCapacity() {
        return this.buffer.capacity;
    }

    public void setCapacity(double capacity) {
        this.buffer.capacity = capacity;
        if (this.buffer.storage > this.buffer.capacity) {
            this.buffer.storage = this.buffer.capacity;
        }
    }

    public double getEnergy() {
        return this.buffer.storage;
    }

    public double getFillRatio() {
        return this.buffer.storage / this.buffer.capacity;
    }

    public double addEnergy(double amount) {
        this.buffer.storage += amount * this.coef;
        this.buffer.storage = Math.min(this.buffer.storage, this.buffer.capacity);
        this.buffer.storage = Math.max(this.buffer.storage, 0.0);
        if (this.upgrade) {
            this.buffer.storage = 0.0;
        }
        if (this.delegate instanceof ICoolSink && !cooling) {
            this.buffer.storage = 0.0;
        }
        return amount;
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return this.upgrade;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        this.upgrade = false;
        this.meta = 0;
        return new ItemStack((ItemLike)IUItem.coolupgrade.getStack(this.meta));
    }

    public boolean canUseEnergy(double amount) {
        return this.buffer.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.buffer.storage >= amount / this.coef) {
            this.buffer.storage -= amount / this.coef;
            if (this.buffer.storage <= 0.005) {
                this.buffer.storage = 0.0;
            }
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        if (this.buffer.storage <= 0.0) {
            this.buffer.storage = 0.0;
            return amount;
        }
        double ret = Math.abs(Math.max(0.0, amount - this.buffer.storage) - amount) / this.coef;
        if (!simulate) {
            this.buffer.storage -= ret / this.coef;
            if (this.buffer.storage <= 0.005) {
                this.buffer.storage = 0.0;
            }
        }
        return ret;
    }

    public int getSinkTier() {
        return this.buffer.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.buffer.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.buffer.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.buffer.sourceTier = tier;
    }

    public void setDirections(Set<Direction> sinkDirections, Set<Direction> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.m_58904_().f_46443_);
            this.delegate.sinkDirections = sinkDirections;
            this.delegate.sourceDirections = sourceDirections;
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this.delegate, this.world));
        }
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            this.delegate.sinkDirections = sinkDirections;
            this.delegate.sourceDirections = sourceDirections;
            assert (!this.parent.m_58904_().f_46443_);
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this.delegate, this.world));
        }
    }

    public Set<Direction> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<Direction> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public ICoolTile getDelegate() {
        return this.delegate;
    }

    private double getSourceEnergy() {
        return this.buffer.storage;
    }
}

