/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.api.pollution.soil.PollutionSoilLoadEvent;
import com.denfop.api.pollution.soil.PollutionSoilUnLoadEvent;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.PollutionMechanism;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.Localization;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SoilPollutionComponent
extends AbstractComponent {
    private PollutionMechanism pollution;
    private double default_pollution;
    private ChunkPos chunkPos;
    private double percent = 1.0;

    public SoilPollutionComponent(BlockEntityInventory parent, double pollution) {
        super(parent);
        this.pollution = new PollutionMechanism(new ChunkPos(parent.pos));
        this.default_pollution = pollution;
    }

    public static void spawnSoilPollution(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.1;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.3f) {
            Vector3f dirtyColor = new Vector3f(0.2f, 0.4f, 0.1f);
            server.m_8767_((ParticleOptions)new DustParticleOptions(dirtyColor, 0.8f), x, y, z, 2, 0.02, 0.005, 0.02, 0.001);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.parent != null && this.parent.getWorld() == null) {
            tooltip.add(Localization.translate("iu.pollution.soil.info") + " " + String.format("%.2f", this.default_pollution) + Localization.translate("iu.pollution.soil.info1"));
        }
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tagCompound = super.writeToNbt();
        tagCompound.m_128347_("percent", this.percent);
        return tagCompound;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.percent = nbt.m_128459_("percent");
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return this.percent != 1.0;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        if (this.percent == 0.0) {
            this.percent = 0.5;
            return new ItemStack((ItemLike)IUItem.antisoilpollution1.getItem());
        }
        this.percent = 1.0;
        return new ItemStack((ItemLike)IUItem.antisoilpollution.getItem());
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.percent == 0.0) {
            ret.add(new ItemStack((ItemLike)IUItem.antisoilpollution1.getItem()));
            ret.add(new ItemStack((ItemLike)IUItem.antisoilpollution.getItem()));
        } else if (this.percent == 0.5) {
            ret.add(new ItemStack((ItemLike)IUItem.antisoilpollution.getItem()));
        }
        return ret;
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        if (!this.parent.m_58904_().f_46443_) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (this.percent == 1.0 && item == IUItem.antisoilpollution.getItem()) {
                stack.m_41774_(1);
                this.percent = 0.5;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            } else if (this.percent == 0.5 && item == IUItem.antisoilpollution1.getItem()) {
                stack.m_41774_(1);
                this.percent = 0.0;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            }
        }
        return super.onBlockActivated(player, hand);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.parent.getWorld().m_46467_() % 20L == 0L && this.parent.getActive()) {
            SoilPollutionComponent.spawnSoilPollution(this.parent.getWorld(), this.parent.getPos(), this.parent.getWorld().f_46441_);
        }
        if (this.parent.getActive()) {
            this.setPollution(this.default_pollution * this.percent);
        } else {
            this.setPollution(0.0);
        }
    }

    @Override
    public void onLoaded() {
        if (!this.parent.m_58904_().f_46443_ && this.parent.m_58904_().m_46472_() == Level.f_46428_) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionSoilLoadEvent(this.parent.m_58904_(), this.pollution));
        }
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.pollution.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.pollution.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.pollution.pollution = is.readDouble();
        this.default_pollution = is.readDouble();
        this.percent = is.readDouble();
    }

    public double getDefault_pollution() {
        return this.default_pollution;
    }

    @Override
    public void onUnloaded() {
        if (!this.parent.m_58904_().f_46443_ && this.parent.m_58904_().m_46472_() == Level.f_46428_) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionSoilUnLoadEvent(this.parent.m_58904_(), this.pollution));
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public void setPollution(double pollution) {
        if (this.pollution.pollution != pollution && !this.parent.m_58904_().f_46443_ && this.parent.m_58904_().m_46472_() == Level.f_46428_) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionSoilUnLoadEvent(this.parent.m_58904_(), this.pollution));
            this.pollution.pollution = pollution * this.percent;
            MinecraftForge.EVENT_BUS.post((Event)new PollutionSoilLoadEvent(this.parent.m_58904_(), this.pollution));
        }
    }
}

