/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets.system;

import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.common.interfaces.Acceptor;
import com.denfop.api.otherenergies.common.interfaces.Emitter;
import com.denfop.api.otherenergies.common.interfaces.Tile;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.ComponentBaseEnergy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyNetDelegate
implements Tile {
    public final BufferEnergy buffer;
    public final BlockPos worldPosition;
    private final boolean clientSide;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public double tick1;
    public double tick;
    public Map<Direction, Tile> energyConductorMap = new HashMap<Direction, Tile>();
    public int hashCodeSource;
    protected double pastEnergy;
    protected double perenergy;
    protected double pastEnergy1;
    protected double perenergy1;
    List<InfoTile<Tile>> validReceivers = new LinkedList<InfoTile<Tile>>();
    private long id;

    public EnergyNetDelegate(ComponentBaseEnergy block) {
        this.worldPosition = block.getParent().pos;
        this.clientSide = block.getParent().m_58904_().f_46443_;
        this.sinkDirections = block.sinkDirections;
        this.sourceDirections = block.sourceDirections;
        this.buffer = block.buffer;
    }

    public double getSourceEnergy() {
        return this.buffer.storage;
    }

    @Override
    public BlockPos getPos() {
        return this.worldPosition;
    }

    @Override
    public BlockEntity getTile() {
        return null;
    }

    public boolean acceptsFrom(Emitter var1, Direction var2) {
        for (Direction facing1 : this.sinkDirections) {
            if (facing1.ordinal() != var2.ordinal()) continue;
            return true;
        }
        return false;
    }

    public boolean emitsTo(Acceptor receiver, Direction dir) {
        return this.sourceDirections.contains(dir);
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public void setSinkDirections(Set<Direction> sinkDirections) {
        this.sinkDirections = sinkDirections;
    }

    public void setSourceDirections(Set<Direction> sourceDirections) {
        this.sourceDirections = sourceDirections;
    }

    @Override
    public Map<Direction, Tile> getTiles(EnergyType energyType) {
        return this.energyConductorMap;
    }

    @Override
    public void RemoveTile(EnergyType energyType, Tile tile, Direction facing1) {
        if (!this.clientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<Tile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<Tile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public List<InfoTile<Tile>> getValidReceivers(EnergyType energyType) {
        return this.validReceivers;
    }

    @Override
    public void AddTile(EnergyType energyType, Tile tile, Direction facing1) {
        if (!this.clientSide && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<Tile>(tile, facing1.m_122424_()));
        }
    }
}

