/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue newsystem;
        public final ForgeConfigSpec.BooleanValue enableEasyMode;
        public final ForgeConfigSpec.BooleanValue cableEasyMode;
        public final ForgeConfigSpec.BooleanValue enableExplosion;
        public final ForgeConfigSpec.BooleanValue enableLosing;
        public final ForgeConfigSpec.IntValue maxVein;
        public final ForgeConfigSpec.IntValue gasMaxVein;
        public final ForgeConfigSpec.IntValue gasChance;
        public final ForgeConfigSpec.BooleanValue airPollution;
        public final ForgeConfigSpec.BooleanValue soilPollution;
        public final ForgeConfigSpec.BooleanValue pressureWork;
        public final ForgeConfigSpec.BooleanValue damageRadiation;
        public final ForgeConfigSpec.BooleanValue informationText;
        public final ForgeConfigSpec.BooleanValue radiationChunksEnabled;
        public final ForgeConfigSpec.BooleanValue radiationDamageEnabled;
        public final ForgeConfigSpec.BooleanValue radiationAccumulationEnabled;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.maxVein = builder.comment("Maximum amount of ore in a vein").defineInRange("maxVein", 30000, 1, Integer.MAX_VALUE);
            this.gasMaxVein = builder.comment("Maximum amount of mb in a gas vein (not natural gas)").defineInRange("gasMaxVein", 200000, 1, Integer.MAX_VALUE);
            this.gasChance = builder.comment("Chance to get a gas vein (not natural gas)").defineInRange("gasChance", 25, 1, 100);
            builder.pop();
            builder.push("Information Text");
            this.informationText = builder.comment("Informational text when logging the game").define("enable", true);
            builder.pop();
            builder.push("TransformerMode");
            this.newsystem = builder.comment("Transformer mode enabled").define("TransformerMode", true);
            this.enableEasyMode = builder.comment("Unchecking the tier").define("enableUnchecking", false);
            this.cableEasyMode = builder.comment("Unlimiting the conduction of energy in the cable").define("cableUnlimiting", false);
            this.enableExplosion = builder.comment("Enable explosion from mechanisms if transformer mode is on").define("enableExplosion", true);
            this.enableLosing = builder.comment("Enable lose energy in cables if transformer mode is on").define("enableLosing", true);
            builder.pop();
            builder.push("pollution");
            this.airPollution = builder.comment("Air pollution").define("airPollution", true);
            this.soilPollution = builder.comment("Soil pollution").define("soilPollution", true);
            builder.pop();
            builder.push("Pressure Network");
            this.pressureWork = builder.comment("Remove the pressure level restriction in the pressure system (allows machines to work at any pressure level)").define("pressureRestriction", true);
            builder.pop();
            builder.push("Radiation");
            this.damageRadiation = builder.comment("Enable damage from radiation").define("radiationDamageEnabled", true);
            this.radiationChunksEnabled = builder.comment("Enable radiation chunks generation").define("radiationChunksEnabled", true);
            this.radiationDamageEnabled = builder.comment("Enable damage from radiation chunk").define("radiationDamageEnabled", true);
            this.radiationAccumulationEnabled = builder.comment("Enable radiation accumulation on the player").define("radiationAccumulationEnabled", true);
            builder.pop();
        }
    }
}

